/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.empire.data.DataMode;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBIndex;
import org.apache.empire.db.DBRecord;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.exceptions.NoPrimaryKeyException;
import org.apache.empire.db.exceptions.RecordDeleteFailedException;
import org.apache.empire.db.exceptions.RecordUpdateInvalidException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemExistsException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBTable
extends DBRowSet
implements Cloneable {
    public static final int DEFAULT = 0;
    public static final int SMALLINT = 2;
    public static final int MEDIUMINT = 4;
    public static final int BIGINT = 8;
    private static final long serialVersionUID = 1L;
    private static AtomicInteger tableCount = new AtomicInteger(0);
    private final String name;
    private String alias;
    private List<DBIndex> indexes = new ArrayList<DBIndex>();
    private boolean cascadeDelete = false;
    private Boolean quoteName = null;

    public DBTable(String name, DBDatabase db) {
        super(db);
        this.name = name;
        this.alias = "t" + String.valueOf(tableCount.incrementAndGet());
        if (db != null) {
            db.addTable(this);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public boolean isUpdateable() {
        return true;
    }

    public Object clone() {
        try {
            DBTable clone = (DBTable)super.clone();
            Class<?> colClass = ((DBColumn)this.columns.get(0)).getClass();
            Class<?> colBase = colClass.getSuperclass();
            clone.columns = new ArrayList();
            Field[] fields = this.getClass().getFields();
            for (int i = 0; i < this.columns.size(); ++i) {
                DBTableColumn srcCol = (DBTableColumn)this.columns.get(i);
                DBTableColumn newCol = new DBTableColumn(clone, srcCol);
                for (int j = 0; j < fields.length; ++j) {
                    Class<?> type = fields[j].getType();
                    if (type != colClass && type != colBase) continue;
                    try {
                        if (fields[j].get(clone) != srcCol) continue;
                        fields[j].set(clone, newCol);
                        continue;
                    }
                    catch (Exception e) {
                        String fieldName = fields[j].getName();
                        log.error("Cannot adjust declared table field: " + fieldName + ". Reason is: " + e.getMessage());
                        CloneNotSupportedException cnse = new CloneNotSupportedException("Unable to replace field reference for field " + fieldName);
                        cnse.initCause(e);
                        throw cnse;
                    }
                }
            }
            clone.alias = "t" + String.valueOf(tableCount.incrementAndGet());
            log.info("clone: Table " + this.name + " cloned! Alias old=" + this.alias + " new=" + clone.alias);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            log.error("Unable to clone table " + this.getName());
            throw new RuntimeException(e);
        }
    }

    protected void addColumn(DBTableColumn column) {
        if (column == null || column.getRowSet() != this) {
            throw new InvalidArgumentException("column", column);
        }
        if (this.getColumn(column.getName()) != null) {
            throw new ItemExistsException((Object)column.getName());
        }
        this.columns.add(column);
    }

    public final DBTableColumn addColumn(String columnName, DataType type, double size, DataMode dataMode, Object defValue) {
        return new DBTableColumn(this, type, columnName, size, dataMode, defValue);
    }

    public final DBTableColumn addColumn(String columnName, DataType type, double size, DataMode dataMode) {
        return new DBTableColumn(this, type, columnName, size, dataMode, null);
    }

    public final DBTableColumn addColumn(String columnName, DataType type, double size, boolean required, Object defValue) {
        DataMode dm = required ? DataMode.NotNull : DataMode.Nullable;
        return new DBTableColumn(this, type, columnName, size, dm, defValue);
    }

    public final DBTableColumn addColumn(String columnName, DataType type, double size, boolean required) {
        DataMode dm = required ? DataMode.NotNull : DataMode.Nullable;
        return new DBTableColumn(this, type, columnName, size, dm, null);
    }

    public DBIndex getPrimaryKey() {
        return this.primaryKey;
    }

    public List<DBIndex> getIndexes() {
        return this.indexes;
    }

    public void setPrimaryKey(DBColumn[] columns) {
        if (columns == null || columns.length == 0) {
            throw new InvalidArgumentException("columns", columns);
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getRowSet() == this) continue;
            throw new InvalidArgumentException("columns[" + String.valueOf(i) + "]", columns[i].getFullName());
        }
        this.primaryKey = new DBIndex(this.name + "_PK", 2, columns);
    }

    public final void setPrimaryKey(DBColumn column) {
        this.setPrimaryKey(new DBColumn[]{column});
    }

    public final void setPrimaryKey(DBColumn col1, DBColumn col2) {
        this.setPrimaryKey(new DBColumn[]{col1, col2});
    }

    public final void setPrimaryKey(DBColumn col1, DBColumn col2, DBColumn col3) {
        this.setPrimaryKey(new DBColumn[]{col1, col2, col3});
    }

    public DBIndex addIndex(DBIndex index) {
        if (index == null) {
            throw new InvalidArgumentException("index", null);
        }
        String name = index.getName();
        for (DBIndex i : this.indexes) {
            if (i != index && !name.equalsIgnoreCase(i.getName())) continue;
            throw new ItemExistsException((Object)name);
        }
        this.indexes.add(index);
        index.setTable(this);
        return index;
    }

    public final DBIndex addIndex(String name, boolean unique, DBColumn[] columns) {
        if (name == null || columns == null || columns.length == 0) {
            throw new InvalidArgumentException("name|columns", null);
        }
        DBIndex index = new DBIndex(name, unique ? 1 : 0, columns);
        this.addIndex(index);
        return index;
    }

    public DBTableColumn addTimestampColumn(String columnName) {
        DBTableColumn col = this.addColumn(columnName, DataType.DATETIME, 0.0, DataMode.AutoGenerated, (Object)DBDatabase.SYSDATE);
        this.setTimestampColumn(col);
        return col;
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        if ((context & 1L | 2L) != 0L) {
            DBDatabaseDriver driver = this.getDatabase().getDriver();
            if (this.quoteName == null) {
                this.quoteName = driver.detectQuoteName(this.name);
            }
            this.db.appendQualifiedName(buf, this.name, this.quoteName);
        }
        if ((context & 8L) != 0L && this.alias != null) {
            buf.append(this.getRenameTablePhrase());
            buf.append(this.alias);
        }
    }

    @Override
    public void createRecord(DBRecord rec, Connection conn) {
        this.prepareInitRecord(rec, 3, null);
        int count = this.columns.size();
        for (int i = 0; i < count; ++i) {
            DBTableColumn column = (DBTableColumn)this.columns.get(i);
            Object value = column.getRecordDefaultValue(conn);
            if (value == null) continue;
            rec.modifyValue(i, value);
        }
        this.completeInitRecord(rec);
    }

    public boolean isCascadeDelete() {
        return this.cascadeDelete;
    }

    public void setCascadeDelete(boolean cascadeDelete) {
        this.cascadeDelete = cascadeDelete;
    }

    @Override
    public void deleteRecord(Object[] key, Connection conn) {
        if (this.primaryKey == null) {
            throw new NoPrimaryKeyException(this);
        }
        DBColumn[] keyColumns = this.primaryKey.getColumns();
        if (key == null || key.length != keyColumns.length) {
            throw new InvalidArgumentException("key", key);
        }
        this.deleteAllReferences(key, conn);
        DBCommand cmd = this.db.createCommand();
        this.setKeyConstraints(cmd, key);
        String sqlCmd = cmd.getDelete(this);
        int affected = this.db.executeSQL(sqlCmd, cmd.getParamValues(), conn);
        if (affected < 0) {
            throw new UnexpectedReturnValueException(affected, "db.executeSQL()");
        }
        if (affected == 0) {
            throw new RecordDeleteFailedException(this, key);
        }
        if (affected > 1) {
            throw new RecordUpdateInvalidException(this, key);
        }
    }
}

