/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Set;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.xml.XMLUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBAbstractFuncExpr
extends DBColumnExpr {
    private static final long serialVersionUID = 1L;
    protected final DBColumnExpr expr;
    protected final DBColumn updateColumn;
    protected final boolean isAggregate;
    protected final DataType dataType;

    public DBAbstractFuncExpr(DBColumnExpr expr, DBColumn updateColumn, boolean isAggregate, DataType dataType) {
        this.expr = expr;
        this.updateColumn = updateColumn;
        this.isAggregate = isAggregate;
        this.dataType = dataType;
    }

    protected abstract String getFunctionName();

    protected final DBDatabaseDriver getDatabaseDriver() {
        DBDatabase db = this.getDatabase();
        return db != null ? db.getDriver() : null;
    }

    @Override
    public DBDatabase getDatabase() {
        return this.expr.getDatabase();
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public String getName() {
        return this.expr.getName();
    }

    @Override
    public DBColumn getUpdateColumn() {
        return this.updateColumn;
    }

    @Override
    public boolean isAggregate() {
        return this.isAggregate || this.expr.isAggregate();
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.expr.addReferencedColumns(list);
    }

    public final void addSQL(StringBuilder sql, String template, Object[] params, long context) {
        if (params != null) {
            DataType dataType = this.expr.getDataType();
            for (int i = 0; i < params.length; ++i) {
                String value = this.getObjectValue(dataType, params[i], 7L, ",");
                template = StringUtils.replaceAll(template, "{" + String.valueOf(i) + "}", value);
            }
        }
        String prefix = template;
        String postfix = "";
        int sep = template.indexOf("?");
        if (sep >= 0) {
            prefix = template.substring(0, sep);
            postfix = template.substring(sep + 1);
        }
        sql.append(prefix);
        this.expr.addSQL(sql, context & 0xFFFFFFFFFFFFFFF7L);
        sql.append(postfix);
    }

    @Override
    public Element addXml(Element parent, long flags) {
        Element elem;
        if (this.updateColumn != null) {
            elem = this.updateColumn.addXml(parent, flags);
        } else {
            elem = XMLUtil.addElement(parent, "column");
            elem.setAttribute("name", this.getName());
            if (this.attributes != null) {
                this.attributes.addXml(elem, flags);
            }
            if (this.options != null) {
                this.options.addXml(elem, flags);
            }
        }
        elem.setAttribute("function", this.getFunctionName());
        return elem;
    }
}

