/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Set;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBAliasExpr
extends DBColumnExpr {
    private static final long serialVersionUID = 1L;
    private final DBColumnExpr expr;
    private final String alias;

    public DBAliasExpr(DBColumnExpr expr, String alias) {
        this.expr = expr.getClass().equals(this.getClass()) ? ((DBAliasExpr)expr).expr : expr;
        this.alias = alias;
    }

    @Override
    public DBDatabase getDatabase() {
        return this.expr.getDatabase();
    }

    @Override
    public DataType getDataType() {
        return this.expr.getDataType();
    }

    @Override
    public String getName() {
        return this.alias;
    }

    public DBColumnExpr getExpr() {
        return this.expr;
    }

    @Override
    public Element addXml(Element parent, long flags) {
        Element field = this.expr.addXml(parent, flags);
        if (field != null) {
            if (field.hasAttribute("name")) {
                field.setAttribute("source", StringUtils.toString(field.getAttribute("name")));
            }
            field.setAttribute("name", this.alias);
        }
        return field;
    }

    @Override
    public DBColumn getUpdateColumn() {
        return this.expr.getUpdateColumn();
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.expr.addReferencedColumns(list);
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        if ((context & 8L) != 0L) {
            this.expr.addSQL(buf, context);
            String asExpr = this.getDatabase().getDriver().getSQLPhrase(4);
            if (asExpr != null) {
                buf.append(asExpr);
                buf.append(this.alias);
            }
        } else {
            this.expr.addSQL(buf, context);
        }
    }

    public boolean equals(Object other) {
        if (super.equals(other)) {
            return true;
        }
        if (other instanceof DBAliasExpr) {
            DBAliasExpr otherExpr = (DBAliasExpr)other;
            return this.alias.equalsIgnoreCase(otherExpr.getName()) && this.expr.equals(otherExpr.getExpr());
        }
        return false;
    }

    public String toString() {
        return this.alias;
    }
}

