/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Set;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCalcExpr
extends DBColumnExpr {
    private static final long serialVersionUID = 1L;
    private final DBColumnExpr expr;
    private final String op;
    private final Object value;

    public DBCalcExpr(DBColumnExpr expr, String op, Object value) {
        this.expr = expr;
        this.value = value;
        this.op = op;
    }

    @Override
    public DBDatabase getDatabase() {
        return this.expr.getDatabase();
    }

    @Override
    public DataType getDataType() {
        return DataType.DECIMAL;
    }

    @Override
    public String getName() {
        return this.expr.getName();
    }

    @Override
    public Element addXml(Element parent, long flags) {
        this.expr.addXml(parent, flags);
        if (this.value instanceof DBColumnExpr) {
            ((DBColumnExpr)this.value).addXml(parent, flags);
        }
        return parent;
    }

    @Override
    public DBColumn getUpdateColumn() {
        return null;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.expr.addReferencedColumns(list);
        if (this.value instanceof DBExpr) {
            ((DBExpr)this.value).addReferencedColumns(list);
        }
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        this.expr.addSQL(buf, context);
        buf.append(this.op);
        buf.append(this.getObjectValue(this.getDataType(), this.value, context, this.op));
    }

    public String toString() {
        String name = this.expr.toString();
        name = name + "_X_";
        name = name + this.value.toString();
        return name;
    }
}

