/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Map;
import java.util.Set;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.expr.column.DBAbstractFuncExpr;
import org.apache.empire.db.expr.column.DBValueExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBDecodeExpr
extends DBAbstractFuncExpr {
    private static final long serialVersionUID = 1L;
    private final Map<?, ?> valueMap;
    private final Object elseExpr;

    public DBDecodeExpr(DBColumnExpr expr, Map<?, ?> valueMap, Object elseExpr, DataType dataType) {
        super(expr, expr.getUpdateColumn(), false, dataType);
        this.valueMap = valueMap;
        this.elseExpr = elseExpr;
    }

    @Override
    protected String getFunctionName() {
        return "decode";
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.expr.addReferencedColumns(list);
        for (Map.Entry<?, ?> e : this.valueMap.entrySet()) {
            if (e.getKey() instanceof DBExpr) {
                ((DBExpr)e.getKey()).addReferencedColumns(list);
            }
            if (!(e.getValue() instanceof DBExpr)) continue;
            ((DBExpr)e.getValue()).addReferencedColumns(list);
        }
        if (this.elseExpr instanceof DBExpr) {
            ((DBExpr)this.elseExpr).addReferencedColumns(list);
        }
    }

    @Override
    public void addSQL(StringBuilder sql, long context) {
        DBDatabaseDriver driver = this.getDatabase().getDriver();
        StringBuilder inner = new StringBuilder();
        for (Object key : this.valueMap.keySet()) {
            Object val = this.valueMap.get(key);
            String part = driver.getSQLPhrase(152);
            part = StringUtils.replaceAll(part, "{0}", this.getObjectValue(this.expr.getDataType(), key, 7L, ""));
            part = StringUtils.replaceAll(part, "{1}", this.getObjectValue(this.getDataType(), val, 7L, ""));
            inner.append(driver.getSQLPhrase(151));
            inner.append(part);
        }
        if (this.elseExpr != null) {
            String other = driver.getSQLPhrase(153);
            other = StringUtils.replaceAll(other, "{0}", this.getObjectValue(this.getDataType(), this.elseExpr, 7L, ""));
            inner.append(driver.getSQLPhrase(151));
            inner.append(other);
        }
        DBValueExpr param = new DBValueExpr(this.getDatabase(), inner, DataType.UNKNOWN);
        String template = driver.getSQLPhrase(150);
        super.addSQL(sql, template, new Object[]{param}, context);
    }
}

