/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.hsql;

import org.apache.empire.data.DataType;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.hsql.DBDatabaseDriverHSql;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSqlDDLGenerator
extends DBDDLGenerator<DBDatabaseDriverHSql> {
    public HSqlDDLGenerator(DBDatabaseDriverHSql driver) {
        super(driver);
        this.initDataTypes();
    }

    private void initDataTypes() {
        this.DATATYPE_CLOB = "LONGVARCHAR";
        this.DATATYPE_BLOB = "LONGVARBINARY";
    }

    @Override
    protected void createDatabase(DBDatabase db, DBSQLScript script) {
        for (DBTable table : db.getTables()) {
            for (DBTableColumn dBTableColumn : table.getColumns()) {
                if (dBTableColumn.getDataType() != DataType.AUTOINC) continue;
                this.createSequence(db, dBTableColumn, script);
            }
        }
        super.createDatabase(db, script);
    }

    protected void createSequence(DBDatabase db, DBTableColumn c, DBSQLScript script) {
        Object defValue = c.getDefaultValue();
        String seqName = defValue != null ? defValue.toString() : c.toString();
        StringBuilder sql = new StringBuilder();
        sql.append("-- creating sequence for column ");
        sql.append(c.toString());
        sql.append(" --\r\n");
        sql.append("CREATE SEQUENCE ");
        db.appendQualifiedName(sql, seqName, this.detectQuoteName(seqName));
        sql.append(" START WITH 1");
        script.addStmt(sql);
    }
}

