/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmdType;
import org.apache.empire.db.DBCombinedCmd;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBDriverFeature;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.exceptions.InternalSQLException;
import org.apache.empire.db.mysql.MySQLDDLGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBDatabaseDriverMySQL
extends DBDatabaseDriver {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DBDatabaseDriverMySQL.class);
    private String databaseName = null;
    private String characterSet = "utf8";
    private boolean useSequenceTable = false;
    private String sequenceTableName = "Sequences";
    private String engine;
    private DBDDLGenerator<?> ddlGenerator = null;

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(String characterSet) {
        this.characterSet = characterSet;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public boolean isUseSequenceTable() {
        return this.useSequenceTable;
    }

    public void setUseSequenceTable(boolean useSequenceTable) {
        this.useSequenceTable = useSequenceTable;
    }

    public String getSequenceTableName() {
        return this.sequenceTableName;
    }

    public void setSequenceTableName(String sequenceTableName) {
        this.sequenceTableName = sequenceTableName;
    }

    public void attachDatabase(DBDatabase db, Connection conn) {
        try {
            if (StringUtils.isNotEmpty(this.databaseName)) {
                this.executeSQL("USE " + this.databaseName, null, conn, null);
            }
            if (this.useSequenceTable && db.getTable(this.sequenceTableName) == null) {
                new DBDatabaseDriver.DBSeqTable(this.sequenceTableName, db);
            }
            super.attachDatabase(db, conn);
        }
        catch (SQLException e) {
            throw new InternalSQLException(this, e);
        }
    }

    public DBCommand createCommand(DBDatabase db) {
        if (db == null) {
            return null;
        }
        return new DBCommandMySQL(db);
    }

    public DBCommandExpr createCombinedCommand(DBCommandExpr left, String keyWord, DBCommandExpr right) {
        return new DBCombinedCmd(left, keyWord, right){
            private static final long serialVersionUID = 1L;
            protected int limit;
            protected int skip;
            {
                this.limit = -1;
                this.skip = -1;
            }

            public void limitRows(int numRows) {
                this.limit = numRows;
            }

            public void skipRows(int numRows) {
                this.skip = numRows;
            }

            public void clearLimit() {
                this.limit = -1;
                this.skip = -1;
            }

            public void getSelect(StringBuilder buf) {
                super.getSelect(buf);
                if (this.limit >= 0) {
                    buf.append("\r\nLIMIT ");
                    buf.append(String.valueOf(this.limit));
                    if (this.skip >= 0) {
                        buf.append(" OFFSET ");
                        buf.append(String.valueOf(this.skip));
                    }
                }
            }
        };
    }

    public boolean isSupported(DBDriverFeature type) {
        switch (type) {
            case CREATE_SCHEMA: {
                return true;
            }
            case SEQUENCES: {
                return this.useSequenceTable;
            }
            case QUERY_LIMIT_ROWS: {
                return true;
            }
            case QUERY_SKIP_ROWS: {
                return true;
            }
        }
        return false;
    }

    public String getSQLPhrase(int phrase) {
        switch (phrase) {
            case 1: {
                return "null";
            }
            case 2: {
                return " ? ";
            }
            case 3: {
                return " ";
            }
            case 4: {
                return " AS ";
            }
            case 5: {
                return "@";
            }
            case 6: {
                return "`";
            }
            case 7: {
                return "`";
            }
            case 8: {
                return "concat(?, {0})";
            }
            case 10: {
                return "1";
            }
            case 11: {
                return "0";
            }
            case 20: {
                return "CURRENT_DATE()";
            }
            case 21: {
                return "yyyy-MM-dd";
            }
            case 22: {
                return "'{0}'";
            }
            case 25: {
                return "NOW()";
            }
            case 26: {
                return "yyyy-MM-dd HH:mm:ss";
            }
            case 27: {
                return "'{0}'";
            }
            case 100: {
                return "coalesce(?, {0})";
            }
            case 101: {
                return "substring(?, {0})";
            }
            case 102: {
                return "substring(?, {0}, {1})";
            }
            case 103: {
                return "replace(?, {0}, {1})";
            }
            case 104: {
                return "reverse(?)";
            }
            case 105: {
                return "instr(?, {0})";
            }
            case 106: {
                return "locate({0}, ?, {1})";
            }
            case 107: {
                return "length(?)";
            }
            case 110: {
                return "upper(?)";
            }
            case 111: {
                return "lcase(?)";
            }
            case 112: {
                return "trim(?)";
            }
            case 113: {
                return "ltrim(?)";
            }
            case 114: {
                return "rtrim(?)";
            }
            case 119: {
                return "? escape '{0}'";
            }
            case 120: {
                return "abs(?)";
            }
            case 121: {
                return "round(?,{0})";
            }
            case 122: {
                return "truncate(?,{0})";
            }
            case 124: {
                return "ceiling(?)";
            }
            case 123: {
                return "floor(?)";
            }
            case 132: {
                return "day(?)";
            }
            case 133: {
                return "month(?)";
            }
            case 134: {
                return "year(?)";
            }
            case 140: {
                return "sum(?)";
            }
            case 142: {
                return "max(?)";
            }
            case 143: {
                return "min(?)";
            }
            case 144: {
                return "avg(?)";
            }
            case 150: {
                return "case ? {0} end";
            }
            case 151: {
                return " ";
            }
            case 152: {
                return "when {0} then {1}";
            }
            case 153: {
                return "else {0}";
            }
        }
        log.error("SQL phrase " + String.valueOf(phrase) + " is not defined!");
        return "?";
    }

    public String getConvertPhrase(DataType destType, DataType srcType, Object format) {
        switch (destType) {
            case BOOL: {
                return "CAST(? AS UNSIGNED)";
            }
            case INTEGER: {
                return "CAST(? AS SIGNED)";
            }
            case DECIMAL: {
                return "CAST(? AS DECIMAL)";
            }
            case FLOAT: {
                return "CAST(? AS DECIMAL)";
            }
            case DATE: {
                return "CAST(? AS DATE)";
            }
            case DATETIME: {
                return "CAST(? AS DATETIME)";
            }
            case TEXT: {
                return "CAST(? AS CHAR)";
            }
            case BLOB: {
                return "CAST(? AS BLOB)";
            }
        }
        log.error("getConvertPhrase: unknown type " + (Object)((Object)destType));
        return "?";
    }

    public Object getNextSequenceValue(DBDatabase db, String seqName, int minValue, Connection conn) {
        if (this.useSequenceTable) {
            DBTable t = db.getTable(this.sequenceTableName);
            return ((DBDatabaseDriver.DBSeqTable)t).getNextValue(seqName, minValue, conn);
        }
        return null;
    }

    public Timestamp getUpdateTimestamp(Connection conn) {
        GregorianCalendar cal = new GregorianCalendar();
        return new Timestamp(cal.getTimeInMillis());
    }

    public void getDDLScript(DBCmdType type, DBObject dbo, DBSQLScript script) {
        if (this.ddlGenerator == null) {
            this.ddlGenerator = new MySQLDDLGenerator(this);
        }
        this.ddlGenerator.getDDLScript(type, dbo, script);
    }

    public static class DBCommandMySQL
    extends DBCommand {
        private static final long serialVersionUID = 1L;
        protected int limit = -1;
        protected int skip = -1;

        public DBCommandMySQL(DBDatabase db) {
            super(db);
        }

        public void limitRows(int numRows) {
            this.limit = numRows;
        }

        public void skipRows(int numRows) {
            this.skip = numRows;
        }

        public void clearLimit() {
            this.limit = -1;
            this.skip = -1;
        }

        public void getSelect(StringBuilder buf) {
            super.getSelect(buf);
            if (this.limit >= 0) {
                buf.append("\r\nLIMIT ");
                buf.append(String.valueOf(this.limit));
                if (this.skip >= 0) {
                    buf.append(" OFFSET ");
                    buf.append(String.valueOf(this.skip));
                }
            }
        }
    }
}

