/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.mysql;

import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBIndex;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.mysql.DBDatabaseDriverMySQL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLDDLGenerator
extends DBDDLGenerator<DBDatabaseDriverMySQL> {
    public MySQLDDLGenerator(DBDatabaseDriverMySQL driver) {
        super(driver);
        this.alterColumnPhrase = " MODIFY ";
        this.initDataTypes();
    }

    private void initDataTypes() {
        this.DATATYPE_TIMESTAMP = "DATETIME";
        this.DATATYPE_CLOB = "LONGTEXT";
    }

    @Override
    protected boolean appendColumnDataType(DataType type, double size, DBTableColumn c, StringBuilder sql) {
        switch (type) {
            case AUTOINC: {
                super.appendColumnDataType(type, size, c, sql);
                if (((DBDatabaseDriverMySQL)this.driver).isUseSequenceTable()) break;
                sql.append(" AUTO_INCREMENT");
                break;
            }
            default: {
                return super.appendColumnDataType(type, size, c, sql);
            }
        }
        return true;
    }

    @Override
    protected void createDatabase(DBDatabase db, DBSQLScript script) {
        String databaseName = ((DBDatabaseDriverMySQL)this.driver).getDatabaseName();
        if (StringUtils.isNotEmpty(databaseName)) {
            script.addStmt("CREATE DATABASE IF NOT EXISTS " + databaseName + " CHARACTER SET " + ((DBDatabaseDriverMySQL)this.driver).getCharacterSet());
            script.addStmt("USE " + databaseName);
            if (((DBDatabaseDriverMySQL)this.driver).isUseSequenceTable() && db.getTable(((DBDatabaseDriverMySQL)this.driver).getSequenceTableName()) == null) {
                new DBDatabaseDriver.DBSeqTable(((DBDatabaseDriverMySQL)this.driver).getSequenceTableName(), db);
            }
        }
        super.createDatabase(db, script);
    }

    @Override
    protected void createTable(DBTable t, DBSQLScript script) {
        StringBuilder sql = new StringBuilder();
        sql.append("-- creating table ");
        sql.append(t.getName());
        sql.append(" --\r\n");
        sql.append("CREATE TABLE ");
        t.addSQL(sql, 2L);
        sql.append(" (");
        boolean addSeparator = false;
        for (DBTableColumn dBTableColumn : t.getColumns()) {
            sql.append(addSeparator ? ",\r\n   " : "\r\n   ");
            this.appendColumnDesc(dBTableColumn, false, sql);
            addSeparator = true;
        }
        DBIndex dBIndex = t.getPrimaryKey();
        if (dBIndex != null) {
            sql.append(",\r\n PRIMARY KEY (");
            addSeparator = false;
            DBColumn[] keyColumns = dBIndex.getColumns();
            for (int i = 0; i < keyColumns.length; ++i) {
                sql.append(addSeparator ? ", " : "");
                keyColumns[i].addSQL(sql, 1L);
                addSeparator = true;
            }
            sql.append(")");
        }
        sql.append(")");
        addSeparator = false;
        if (StringUtils.isNotEmpty(((DBDatabaseDriverMySQL)this.driver).getEngine())) {
            sql.append("\r\n ENGINE = ");
            sql.append(((DBDatabaseDriverMySQL)this.driver).getEngine());
            addSeparator = true;
        }
        if (StringUtils.isNotEmpty(t.getComment())) {
            if (addSeparator) {
                sql.append(",");
            }
            sql.append("\r\n COMMENT = '");
            sql.append(t.getComment());
            sql.append("'");
        }
        this.addCreateTableStmt(t, sql, script);
        this.createTableIndexes(t, dBIndex, script);
    }
}

