/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.postgresql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmdType;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBDriverFeature;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.exceptions.InternalSQLException;
import org.apache.empire.db.postgresql.PostgreDDLGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBDatabaseDriverPostgreSQL
extends DBDatabaseDriver {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DBDatabaseDriverPostgreSQL.class);
    private static final String CREATE_REVERSE_FUNCTION = "CREATE OR REPLACE FUNCTION reverse(TEXT) RETURNS TEXT AS '\nDECLARE\n   original ALIAS FOR $1;\n   reversed TEXT := \\'\\';\n   onechar  VARCHAR;\n   mypos    INTEGER;\nBEGIN\n   SELECT LENGTH(original) INTO mypos;\n   LOOP\n      EXIT WHEN mypos < 1;\n      SELECT substring(original FROM mypos FOR 1) INTO onechar;\n      reversed := reversed || onechar;\n      mypos := mypos -1;\n   END LOOP;\n   RETURN reversed;\nEND\n' LANGUAGE plpgsql IMMUTABLE RETURNS NULL ON NULL INPUT";
    private String databaseName;
    private DBDDLGenerator<?> ddlGenerator = null;

    public DBDatabaseDriverPostgreSQL() {
        this.setReservedKeywords();
    }

    private void addReservedKeyWord(String keyWord) {
        boolean added = this.reservedSQLKeywords.add(keyWord.toLowerCase());
        if (!added) {
            log.debug("Existing keyWord added: " + keyWord);
        }
    }

    private void setReservedKeywords() {
        this.addReservedKeyWord("ALL".toLowerCase());
        this.addReservedKeyWord("ANALYSE".toLowerCase());
        this.addReservedKeyWord("ANALYZE".toLowerCase());
        this.addReservedKeyWord("AND".toLowerCase());
        this.addReservedKeyWord("ANY".toLowerCase());
        this.addReservedKeyWord("ARRAY".toLowerCase());
        this.addReservedKeyWord("AS".toLowerCase());
        this.addReservedKeyWord("ASC".toLowerCase());
        this.addReservedKeyWord("ASYMMETRIC".toLowerCase());
        this.addReservedKeyWord("AUTHORIZATION".toLowerCase());
        this.addReservedKeyWord("BETWEEN".toLowerCase());
        this.addReservedKeyWord("BINARY".toLowerCase());
        this.addReservedKeyWord("BOTH".toLowerCase());
        this.addReservedKeyWord("CASE".toLowerCase());
        this.addReservedKeyWord("CAST".toLowerCase());
        this.addReservedKeyWord("CHECK".toLowerCase());
        this.addReservedKeyWord("COLLATE".toLowerCase());
        this.addReservedKeyWord("CREATE".toLowerCase());
        this.addReservedKeyWord("CROSS".toLowerCase());
        this.addReservedKeyWord("CURRENT_DATE".toLowerCase());
        this.addReservedKeyWord("CURRENT_ROLE".toLowerCase());
        this.addReservedKeyWord("CURRENT_TIME".toLowerCase());
        this.addReservedKeyWord("CURRENT_TIMESTAMP".toLowerCase());
        this.addReservedKeyWord("CURRENT_USER".toLowerCase());
        this.addReservedKeyWord("DEFAULT".toLowerCase());
        this.addReservedKeyWord("DEFERRABLE".toLowerCase());
        this.addReservedKeyWord("DESC".toLowerCase());
        this.addReservedKeyWord("DISTINCT".toLowerCase());
        this.addReservedKeyWord("DO".toLowerCase());
        this.addReservedKeyWord("ELSE".toLowerCase());
        this.addReservedKeyWord("END".toLowerCase());
        this.addReservedKeyWord("EXCEPT".toLowerCase());
        this.addReservedKeyWord("FALSE".toLowerCase());
        this.addReservedKeyWord("FOR".toLowerCase());
        this.addReservedKeyWord("FOREIGN".toLowerCase());
        this.addReservedKeyWord("FREEZE".toLowerCase());
        this.addReservedKeyWord("FROM".toLowerCase());
        this.addReservedKeyWord("FULL".toLowerCase());
        this.addReservedKeyWord("GRANT".toLowerCase());
        this.addReservedKeyWord("HAVING".toLowerCase());
        this.addReservedKeyWord("ILIKE".toLowerCase());
        this.addReservedKeyWord("IN".toLowerCase());
        this.addReservedKeyWord("INITIALLY".toLowerCase());
        this.addReservedKeyWord("INNER".toLowerCase());
        this.addReservedKeyWord("INTERSECT".toLowerCase());
        this.addReservedKeyWord("INTO".toLowerCase());
        this.addReservedKeyWord("IS".toLowerCase());
        this.addReservedKeyWord("ISNULL".toLowerCase());
        this.addReservedKeyWord("JOIN".toLowerCase());
        this.addReservedKeyWord("LEADING".toLowerCase());
        this.addReservedKeyWord("LEFT".toLowerCase());
        this.addReservedKeyWord("LIKE".toLowerCase());
        this.addReservedKeyWord("LIMIT".toLowerCase());
        this.addReservedKeyWord("LOCALTIME".toLowerCase());
        this.addReservedKeyWord("LOCALTIMESTAMP".toLowerCase());
        this.addReservedKeyWord("NATURAL".toLowerCase());
        this.addReservedKeyWord("NEW".toLowerCase());
        this.addReservedKeyWord("NOT".toLowerCase());
        this.addReservedKeyWord("NOTNULL".toLowerCase());
        this.addReservedKeyWord("NULL".toLowerCase());
        this.addReservedKeyWord("OFF".toLowerCase());
        this.addReservedKeyWord("OFFSET".toLowerCase());
        this.addReservedKeyWord("OLD".toLowerCase());
        this.addReservedKeyWord("ON".toLowerCase());
        this.addReservedKeyWord("ONLY".toLowerCase());
        this.addReservedKeyWord("OR".toLowerCase());
        this.addReservedKeyWord("ORDER".toLowerCase());
        this.addReservedKeyWord("OUTER".toLowerCase());
        this.addReservedKeyWord("OVERLAPS".toLowerCase());
        this.addReservedKeyWord("PLACING".toLowerCase());
        this.addReservedKeyWord("PRIMARY".toLowerCase());
        this.addReservedKeyWord("REFERENCES".toLowerCase());
        this.addReservedKeyWord("RETURNING".toLowerCase());
        this.addReservedKeyWord("RIGHT".toLowerCase());
        this.addReservedKeyWord("SESSION_USER".toLowerCase());
        this.addReservedKeyWord("SIMILAR".toLowerCase());
        this.addReservedKeyWord("SOME".toLowerCase());
        this.addReservedKeyWord("SYMMETRIC".toLowerCase());
        this.addReservedKeyWord("THEN".toLowerCase());
        this.addReservedKeyWord("TO".toLowerCase());
        this.addReservedKeyWord("TRAILING".toLowerCase());
        this.addReservedKeyWord("TRUE".toLowerCase());
        this.addReservedKeyWord("UNION".toLowerCase());
        this.addReservedKeyWord("UNIQUE".toLowerCase());
        this.addReservedKeyWord("USING".toLowerCase());
        this.addReservedKeyWord("VERBOSE".toLowerCase());
        this.addReservedKeyWord("WHEN".toLowerCase());
        this.addReservedKeyWord("WHERE".toLowerCase());
        this.addReservedKeyWord("WITH".toLowerCase());
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void createReverseFunction(Connection conn) {
        try {
            log.info("Creating reverse function: CREATE OR REPLACE FUNCTION reverse(TEXT) RETURNS TEXT AS '\nDECLARE\n   original ALIAS FOR $1;\n   reversed TEXT := \\'\\';\n   onechar  VARCHAR;\n   mypos    INTEGER;\nBEGIN\n   SELECT LENGTH(original) INTO mypos;\n   LOOP\n      EXIT WHEN mypos < 1;\n      SELECT substring(original FROM mypos FOR 1) INTO onechar;\n      reversed := reversed || onechar;\n      mypos := mypos -1;\n   END LOOP;\n   RETURN reversed;\nEND\n' LANGUAGE plpgsql IMMUTABLE RETURNS NULL ON NULL INPUT");
            this.executeSQL(CREATE_REVERSE_FUNCTION, null, conn, null);
        }
        catch (SQLException e) {
            log.error("Unable to create reverse function!", (Throwable)e);
            throw new InternalSQLException(this, e);
        }
    }

    public DBCommand createCommand(DBDatabase db) {
        if (db == null) {
            return null;
        }
        return new DBCommandPostreSQL(db);
    }

    public boolean isSupported(DBDriverFeature type) {
        switch (type) {
            case CREATE_SCHEMA: {
                return true;
            }
            case SEQUENCES: {
                return true;
            }
            case QUERY_LIMIT_ROWS: {
                return true;
            }
            case QUERY_SKIP_ROWS: {
                return true;
            }
        }
        return false;
    }

    public String getSQLPhrase(int phrase) {
        switch (phrase) {
            case 1: {
                return "null";
            }
            case 2: {
                return " ? ";
            }
            case 3: {
                return " ";
            }
            case 4: {
                return " AS ";
            }
            case 5: {
                return "@";
            }
            case 6: {
                return "\"";
            }
            case 7: {
                return "\"";
            }
            case 8: {
                return "? || {0}";
            }
            case 10: {
                return "TRUE";
            }
            case 11: {
                return "FALSE";
            }
            case 20: {
                return "CURRENT_DATE()";
            }
            case 21: {
                return "yyyy-MM-dd";
            }
            case 22: {
                return "'{0}'";
            }
            case 25: {
                return "NOW()";
            }
            case 26: {
                return "yyyy-MM-dd HH:mm:ss";
            }
            case 27: {
                return "'{0}'";
            }
            case 100: {
                return "coalesce(?, {0})";
            }
            case 101: {
                return "substring(?, {0})";
            }
            case 102: {
                return "substring(?, {0}, {1})";
            }
            case 103: {
                return "replace(?, {0}, {1})";
            }
            case 104: {
                return "reverse(?)";
            }
            case 105: {
                return "strpos(?, {0})";
            }
            case 106: {
                return "strindexfrom_not_available_in_pgsql({0}, ?, {1})";
            }
            case 107: {
                return "length(?)";
            }
            case 110: {
                return "upper(?)";
            }
            case 111: {
                return "lcase(?)";
            }
            case 112: {
                return "trim(?)";
            }
            case 113: {
                return "ltrim(?)";
            }
            case 114: {
                return "rtrim(?)";
            }
            case 119: {
                return "? escape '{0}'";
            }
            case 120: {
                return "abs(?)";
            }
            case 121: {
                return "round(?,{0})";
            }
            case 122: {
                return "truncate(?,{0})";
            }
            case 124: {
                return "ceiling(?)";
            }
            case 123: {
                return "floor(?)";
            }
            case 132: {
                return "day(?)";
            }
            case 133: {
                return "month(?)";
            }
            case 134: {
                return "year(?)";
            }
            case 140: {
                return "sum(?)";
            }
            case 142: {
                return "max(?)";
            }
            case 143: {
                return "min(?)";
            }
            case 144: {
                return "avg(?)";
            }
            case 150: {
                return "case ? {0} end";
            }
            case 151: {
                return " ";
            }
            case 152: {
                return "when {0} then {1}";
            }
            case 153: {
                return "else {0}";
            }
        }
        log.error("SQL phrase " + String.valueOf(phrase) + " is not defined!");
        return "?";
    }

    public String getConvertPhrase(DataType destType, DataType srcType, Object format) {
        switch (destType) {
            case BOOL: {
                return "CAST(? AS BOOL)";
            }
            case INTEGER: {
                return "CAST(? AS INTEGER)";
            }
            case DECIMAL: {
                return "CAST(? AS DECIMAL)";
            }
            case FLOAT: {
                return "CAST(? AS DOUBLE PRECISION)";
            }
            case DATE: {
                return "CAST(? AS DATE)";
            }
            case DATETIME: {
                return "CAST(? AS TIMESTAMP)";
            }
            case TEXT: {
                return "CAST(? AS CHAR)";
            }
            case BLOB: {
                return "CAST(? AS bytea)";
            }
            case CLOB: {
                return "CAST(? AS TEXT)";
            }
        }
        log.error("getConvertPhrase: unknown type (" + String.valueOf((Object)destType));
        return "?";
    }

    public Object getNextSequenceValue(DBDatabase db, String seqName, int minValue, Connection conn) {
        StringBuilder sql = new StringBuilder(80);
        sql.append("SELECT nextval('");
        db.appendQualifiedName(sql, seqName, this.detectQuoteName(seqName));
        sql.append("')");
        Object val = db.querySingleValue(sql.toString(), conn);
        if (val == null) {
            log.error("getNextSequenceValue: Invalid sequence value for sequence " + seqName);
        }
        return val;
    }

    public Timestamp getUpdateTimestamp(Connection conn) {
        GregorianCalendar cal = new GregorianCalendar();
        return new Timestamp(cal.getTimeInMillis());
    }

    public void getDDLScript(DBCmdType type, DBObject dbo, DBSQLScript script) {
        if (this.ddlGenerator == null) {
            this.ddlGenerator = new PostgreDDLGenerator(this);
        }
        this.ddlGenerator.getDDLScript(type, dbo, script);
    }

    public Object getResultValue(ResultSet rset, int columnIndex, DataType dataType) throws SQLException {
        if (dataType == DataType.CLOB) {
            return rset.getString(columnIndex);
        }
        return super.getResultValue(rset, columnIndex, dataType);
    }

    public static class DBCommandPostreSQL
    extends DBCommand {
        private static final long serialVersionUID = 1L;
        protected int limit = -1;
        protected int skip = -1;

        public DBCommandPostreSQL(DBDatabase db) {
            super(db);
        }

        public void limitRows(int numRows) {
            this.limit = numRows;
        }

        public void skipRows(int numRows) {
            this.skip = numRows;
        }

        public void clearLimit() {
            this.limit = -1;
            this.skip = -1;
        }

        public void getSelect(StringBuilder buf) {
            super.getSelect(buf);
            if (this.limit >= 0) {
                buf.append("\r\nLIMIT ");
                buf.append(String.valueOf(this.limit));
                if (this.skip >= 0) {
                    buf.append(" OFFSET ");
                    buf.append(String.valueOf(this.skip));
                }
            }
        }
    }
}

