/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.sqlserver;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmdType;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBDriverFeature;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.exceptions.InternalSQLException;
import org.apache.empire.db.sqlserver.MSSqlDDLGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBDatabaseDriverMSSQL
extends DBDatabaseDriver {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DBDatabaseDriverMSSQL.class);
    private String databaseName = null;
    private String objectOwner = "dbo";
    private String sequenceTableName = "Sequences";
    private boolean useSequenceTable = false;
    private boolean useUnicodePrefix = true;
    private DBDDLGenerator<?> ddlGenerator = null;
    protected static final String[] MSSQL_SQL_KEYWORDS = new String[]{"type", "key"};

    public DBDatabaseDriverMSSQL() {
        for (String keyWord : MSSQL_SQL_KEYWORDS) {
            this.reservedSQLKeywords.add(keyWord);
        }
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getObjectOwner() {
        return this.objectOwner;
    }

    public void setObjectOwner(String objectOwner) {
        this.objectOwner = objectOwner;
    }

    public boolean isUseSequenceTable() {
        return this.useSequenceTable;
    }

    public void setUseSequenceTable(boolean useSequenceTable) {
        this.useSequenceTable = useSequenceTable;
    }

    public String getSequenceTableName() {
        return this.sequenceTableName;
    }

    public void setSequenceTableName(String sequenceTableName) {
        this.sequenceTableName = sequenceTableName;
    }

    public boolean isUseUnicodePrefix() {
        return this.useUnicodePrefix;
    }

    public void setUseUnicodePrefix(boolean useUnicodePrefix) {
        this.useUnicodePrefix = useUnicodePrefix;
    }

    public void attachDatabase(DBDatabase db, Connection conn) {
        try {
            String schema;
            if (StringUtils.isNotEmpty(this.databaseName)) {
                this.executeSQL("USE " + this.databaseName, null, conn, null);
            }
            this.executeSQL("SET DATEFORMAT ymd", null, conn, null);
            if (this.useSequenceTable && db.getTable(this.sequenceTableName) == null) {
                new DBDatabaseDriver.DBSeqTable(this.sequenceTableName, db);
            }
            if (StringUtils.isNotEmpty(schema = db.getSchema()) && schema.indexOf(46) < 0 && StringUtils.isNotEmpty(this.objectOwner)) {
                db.setSchema(schema + "." + this.objectOwner);
            }
            super.attachDatabase(db, conn);
        }
        catch (SQLException e) {
            throw new InternalSQLException(this, e);
        }
    }

    public DBCommand createCommand(DBDatabase db) {
        if (db == null) {
            return null;
        }
        return new DBCommandMSSQL(db);
    }

    public boolean isSupported(DBDriverFeature type) {
        switch (type) {
            case CREATE_SCHEMA: {
                return true;
            }
            case SEQUENCES: {
                return this.useSequenceTable;
            }
            case QUERY_LIMIT_ROWS: {
                return true;
            }
            case QUERY_SKIP_ROWS: {
                return false;
            }
        }
        return false;
    }

    public String getSQLPhrase(int phrase) {
        switch (phrase) {
            case 1: {
                return "null";
            }
            case 2: {
                return " ? ";
            }
            case 3: {
                return " ";
            }
            case 4: {
                return " AS ";
            }
            case 5: {
                return "@";
            }
            case 6: {
                return "[";
            }
            case 7: {
                return "]";
            }
            case 8: {
                return " + ";
            }
            case 10: {
                return "1";
            }
            case 11: {
                return "0";
            }
            case 20: {
                return "convert(char, getdate(), 111)";
            }
            case 21: {
                return "yyyy-MM-dd";
            }
            case 22: {
                return "'{0}'";
            }
            case 25: {
                return "getdate()";
            }
            case 26: {
                return "yyyy-MM-dd HH:mm:ss.SSS";
            }
            case 27: {
                return "'{0}'";
            }
            case 100: {
                return "coalesce(?, {0})";
            }
            case 101: {
                return "substring(?, {0}, 4000)";
            }
            case 102: {
                return "substring(?, {0}, {1})";
            }
            case 103: {
                return "replace(?, {0}, {1})";
            }
            case 104: {
                return "reverse(?)";
            }
            case 105: {
                return "charindex({0}, ?)";
            }
            case 106: {
                return "charindex({0}, ?, {1})";
            }
            case 107: {
                return "len(?)";
            }
            case 110: {
                return "upper(?)";
            }
            case 111: {
                return "lower(?)";
            }
            case 112: {
                return "trim(?)";
            }
            case 113: {
                return "ltrim(?)";
            }
            case 114: {
                return "rtrim(?)";
            }
            case 119: {
                return "? escape '{0}'";
            }
            case 120: {
                return "abs(?)";
            }
            case 121: {
                return "round(?,{0})";
            }
            case 122: {
                return "trunc(?,{0})";
            }
            case 124: {
                return "ceiling(?)";
            }
            case 123: {
                return "floor(?)";
            }
            case 132: {
                return "day(?)";
            }
            case 133: {
                return "month(?)";
            }
            case 134: {
                return "year(?)";
            }
            case 140: {
                return "sum(?)";
            }
            case 142: {
                return "max(?)";
            }
            case 143: {
                return "min(?)";
            }
            case 144: {
                return "avg(?)";
            }
            case 150: {
                return "case ? {0} end";
            }
            case 151: {
                return " ";
            }
            case 152: {
                return "when {0} then {1}";
            }
            case 153: {
                return "else {0}";
            }
        }
        log.error("SQL phrase " + String.valueOf(phrase) + " is not defined!");
        return "?";
    }

    public String getConvertPhrase(DataType destType, DataType srcType, Object format) {
        switch (destType) {
            case BOOL: {
                return "convert(bit, ?)";
            }
            case INTEGER: {
                return "convert(int, ?)";
            }
            case DECIMAL: {
                return "convert(decimal, ?)";
            }
            case FLOAT: {
                return "convert(float, ?)";
            }
            case DATE: {
                return "convert(datetime, ?, 111)";
            }
            case DATETIME: {
                return "convert(datetime, ?, 120)";
            }
            case TEXT: {
                if (srcType == DataType.DATE) {
                    return "replace(convert(nvarchar, ?, 111), '/', '-')";
                }
                if (srcType == DataType.DATETIME) {
                    return "convert(nvarchar, ?, 120)";
                }
                return "convert(nvarchar, ?)";
            }
            case BLOB: {
                return "convert(varbinary, ?)";
            }
        }
        log.error("getConvertPhrase: unknown type " + (Object)((Object)destType));
        return "?";
    }

    public Object getNextSequenceValue(DBDatabase db, String seqName, int minValue, Connection conn) {
        if (this.useSequenceTable) {
            DBTable t = db.getTable(this.sequenceTableName);
            return ((DBDatabaseDriver.DBSeqTable)t).getNextValue(seqName, minValue, conn);
        }
        return null;
    }

    protected String getSQLTextString(DataType type, Object value) {
        StringBuilder valBuf = new StringBuilder();
        valBuf.append(this.useUnicodePrefix ? "N'" : "'");
        if (!"\u0000".equals(value)) {
            this.appendSQLTextValue(valBuf, value.toString());
        }
        valBuf.append("'");
        return valBuf.toString();
    }

    public Timestamp getUpdateTimestamp(Connection conn) {
        GregorianCalendar cal = new GregorianCalendar();
        return new Timestamp(cal.getTimeInMillis());
    }

    public Object getColumnAutoValue(DBDatabase db, DBTableColumn column, Connection conn) {
        if (column.getDataType() == DataType.UNIQUEID) {
            return db.querySingleValue("select newid()", conn);
        }
        return super.getColumnAutoValue(db, column, conn);
    }

    public void getDDLScript(DBCmdType type, DBObject dbo, DBSQLScript script) {
        if (this.ddlGenerator == null) {
            this.ddlGenerator = new MSSqlDDLGenerator(this);
        }
        this.ddlGenerator.getDDLScript(type, dbo, script);
    }

    public static class DBCommandMSSQL
    extends DBCommand {
        private static final long serialVersionUID = 1L;
        protected int limit = -1;

        public DBCommandMSSQL(DBDatabase db) {
            super(db);
        }

        public void limitRows(int numRows) {
            this.limit = numRows;
        }

        public void clearLimit() {
            this.limit = -1;
        }

        protected void addSelect(StringBuilder buf) {
            buf.append("SELECT ");
            if (this.selectDistinct) {
                buf.append("DISTINCT ");
            }
            if (this.limit >= 0) {
                buf.append("TOP ");
                buf.append(String.valueOf(this.limit));
                buf.append(" ");
            }
            this.addListExpr(buf, this.select, 15L, ", ");
        }
    }
}

