/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.exceptions;

import org.apache.empire.commons.ErrorType;
import org.apache.empire.exceptions.EmpireException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanPropertySetException
extends EmpireException {
    private static final Logger log = LoggerFactory.getLogger(BeanPropertySetException.class);
    private static final long serialVersionUID = 1L;
    public static final ErrorType errorType = new ErrorType("error.propertySetError", "The property {0} cannot be set on type {1}.");

    public BeanPropertySetException(Object bean, String property, Throwable cause) {
        super(errorType, new String[]{property, bean != null ? bean.getClass().getName() : "{unknown}"}, cause);
    }

    protected void log() {
        if (log.isErrorEnabled()) {
            log.error(this.getMessage());
        } else {
            super.log();
        }
    }
}

