/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.exceptions;

import java.text.MessageFormat;
import org.apache.empire.commons.ErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmpireException
extends RuntimeException {
    private static final Logger log = LoggerFactory.getLogger(EmpireException.class);
    private static final long serialVersionUID = 1L;
    private final ErrorType errorType;
    private final String[] errorParams;

    private static String formatErrorMessage(ErrorType errType, String[] params) {
        int paramCount;
        int n = paramCount = params != null ? params.length : 0;
        if (paramCount != errType.getNumParams()) {
            log.warn("Invalid Number of arguments supplied for error " + errType.getKey() + "\nArguments supplied= " + String.valueOf(paramCount) + "; Arguments expected= " + String.valueOf(errType.getNumParams()));
        }
        String msg = MessageFormat.format(errType.getMessagePattern(), params);
        return msg;
    }

    protected EmpireException(ErrorType errType, String[] params, Throwable cause) {
        super(EmpireException.formatErrorMessage(errType, params), cause);
        this.errorType = errType;
        this.errorParams = params;
        this.log();
    }

    protected EmpireException(ErrorType errType, String[] params) {
        this(errType, params, null);
    }

    protected void log() {
        if (log.isInfoEnabled()) {
            log.info("An Error occured. Message is: {}", (Object)this.getMessage());
        }
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public String[] getErrorParams() {
        return this.errorParams;
    }
}

