/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.bnd;

import aQute.lib.osgi.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.ipojo.manipulator.MetadataProvider;
import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.manipulator.metadata.StreamMetadataProvider;
import org.apache.felix.ipojo.metadata.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMetadataProvider
implements MetadataProvider {
    private Resource m_resource;
    private List<Element> m_cached;
    private boolean m_validateUsingLocalSchemas = false;
    private Reporter m_reporter;

    public ResourceMetadataProvider(Resource resource, Reporter reporter) {
        this.m_resource = resource;
        this.m_reporter = reporter;
    }

    public void setValidateUsingLocalSchemas(boolean validateUsingLocalSchemas) {
        this.m_validateUsingLocalSchemas = validateUsingLocalSchemas;
    }

    public List<Element> getMetadatas() throws IOException {
        if (this.m_cached == null) {
            this.m_cached = new ArrayList<Element>();
            InputStream stream = null;
            try {
                stream = this.m_resource.openInputStream();
            }
            catch (Exception e) {
                this.m_reporter.error("%s", new Object[]{e.getMessage()});
                throw new IOException("Cannot read metadata", e);
            }
            StreamMetadataProvider provider = new StreamMetadataProvider(stream, this.m_reporter);
            provider.setValidateUsingLocalSchemas(this.m_validateUsingLocalSchemas);
            this.m_cached.addAll(provider.getMetadatas());
        }
        return this.m_cached;
    }
}

