/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Jar;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;
import org.apache.felix.bundleplugin.BundlePlugin;
import org.apache.felix.bundleplugin.PackageVersionAnalyzer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class ManifestPlugin
extends BundlePlugin {
    protected void execute(MavenProject project, Map instructions, Properties properties, Jar[] classpath) throws MojoExecutionException {
        Manifest manifest;
        try {
            manifest = "bundle".equals(project.getPackaging()) ? this.buildOSGiBundle(project, instructions, properties, classpath).getJar().getManifest() : this.getManifest(project, instructions, properties, classpath);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Cannot find " + e.getMessage() + " (manifest goal must be run after compile phase)", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error trying to generate Manifest", (Exception)e);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"An internal error occurred", (Throwable)e);
            throw new MojoExecutionException("Internal error in maven-bundle-plugin", e);
        }
        File outputFile = new File(this.manifestLocation, "MANIFEST.MF");
        try {
            ManifestPlugin.writeManifest(manifest, outputFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error trying to write Manifest to file " + outputFile, (Exception)e);
        }
    }

    public Manifest getManifest(MavenProject project, Jar[] classpath) throws IOException {
        return this.getManifest(project, new Properties(), new Properties(), classpath);
    }

    public Manifest getManifest(MavenProject project, Map instructions, Properties properties, Jar[] classpath) throws IOException {
        return this.getAnalyzer(project, instructions, properties, classpath).getJar().getManifest();
    }

    protected Analyzer getAnalyzer(MavenProject project, Jar[] classpath) throws IOException {
        return this.getAnalyzer(project, new HashMap(), new Properties(), classpath);
    }

    protected Analyzer getAnalyzer(MavenProject project, Map instructions, Properties properties, Jar[] classpath) throws IOException {
        PackageVersionAnalyzer analyzer = new PackageVersionAnalyzer();
        Properties props = this.getDefaultProperties(project);
        props.putAll((Map<?, ?>)properties);
        if (!instructions.containsKey("Import-Package")) {
            props.put("Import-Package", "*");
        }
        props.putAll((Map<?, ?>)ManifestPlugin.transformDirectives(instructions));
        analyzer.setProperties(props);
        File file = project.getArtifact().getFile();
        if (file == null) {
            file = this.getOutputDirectory();
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        analyzer.setJar(file);
        if (classpath != null) {
            analyzer.setClasspath(classpath);
        }
        if (!instructions.containsKey("Private-Package") && !instructions.containsKey("Export-Package")) {
            String export = analyzer.calculateExportsFromContents(analyzer.getJar());
            analyzer.setProperty("Export-Package", export);
        }
        analyzer.mergeManifest(analyzer.getJar().getManifest());
        analyzer.calcManifest();
        return analyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeManifest(Manifest manifest, File outputFile) throws IOException {
        outputFile.getParentFile().mkdirs();
        FileOutputStream os = new FileOutputStream(outputFile);
        try {
            manifest.write(os);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
    }
}

