/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class RelativizePath {
    private RelativizePath() {
    }

    static String convertToRelativePath(File thing, File relativeTo) {
        if (thing.getParentFile().equals(relativeTo.getParentFile())) {
            return thing.getName();
        }
        List<String> thingDirectories = RelativizePath.parentDirs(thing);
        List<String> relativeToDirectories = RelativizePath.parentDirs(relativeTo);
        int length = thingDirectories.size() < relativeToDirectories.size() ? thingDirectories.size() : relativeToDirectories.size();
        int lastCommonRoot = -1;
        int index = 0;
        while (index < length && thingDirectories.get(index).equals(relativeToDirectories.get(index))) {
            lastCommonRoot = index++;
        }
        if (lastCommonRoot != -1) {
            StringBuilder relativePath = new StringBuilder();
            for (index = lastCommonRoot + 1; index < relativeToDirectories.size(); ++index) {
                relativePath.append("../");
            }
            for (index = lastCommonRoot + 1; index < thingDirectories.size(); ++index) {
                relativePath.append(thingDirectories.get(index)).append('/');
            }
            relativePath.append(thing.getName());
            return relativePath.toString();
        }
        return null;
    }

    static List<String> parentDirs(File of) {
        ArrayList<String> results = new ArrayList<String>();
        for (File p = of.getParentFile(); p != null; p = p.getParentFile()) {
            if ("".equals(p.getName())) continue;
            results.add(p.getName());
        }
        Collections.reverse(results);
        return results;
    }
}

