/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl;

import org.apache.felix.eventadmin.impl.handler.HandlerTasks;
import org.apache.felix.eventadmin.impl.tasks.DeliverTask;
import org.apache.felix.eventadmin.impl.tasks.HandlerTask;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class EventAdminImpl
implements EventAdmin {
    private volatile HandlerTasks m_managers;
    private final DeliverTask m_postManager;
    private final DeliverTask m_sendManager;

    public EventAdminImpl(HandlerTasks managers, DeliverTask postManager, DeliverTask sendManager) {
        this.checkNull(managers, "Managers");
        this.checkNull(postManager, "PostManager");
        this.checkNull(sendManager, "SendManager");
        this.m_managers = managers;
        this.m_postManager = postManager;
        this.m_sendManager = sendManager;
    }

    public void postEvent(Event event) {
        this.handleEvent(this.m_managers.createHandlerTasks(event), this.m_postManager);
    }

    public void sendEvent(Event event) {
        this.handleEvent(this.m_managers.createHandlerTasks(event), this.m_sendManager);
    }

    public void stop() {
        this.m_managers = new HandlerTasks(){

            public HandlerTask[] createHandlerTasks(Event event) {
                throw new IllegalStateException("The EventAdmin is stopped");
            }
        };
    }

    private void handleEvent(HandlerTask[] managers, DeliverTask manager) {
        if (0 < managers.length) {
            manager.execute(managers);
        }
    }

    private void checkNull(Object object, String name) {
        if (null == object) {
            throw new NullPointerException(name + " may not be null");
        }
    }
}

