/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import org.apache.felix.http.base.internal.HttpConfig;
import org.apache.felix.http.base.internal.context.ExtServletContext;

public class HttpSessionWrapper
implements HttpSession {
    private static final String PREFIX = "org.apache.felix.http.session.context.";
    private static final String ATTR_PREFIX = "org.apache.felix.http.session.context.attr.";
    private static final String ATTR_CREATED = "org.apache.felix.http.session.context.created.";
    private static final String ATTR_LAST_ACCESSED = "org.apache.felix.http.session.context.lastaccessed.";
    private static final String ATTR_MAX_INACTIVE = "org.apache.felix.http.session.context.maxinactive.";
    private final HttpSession delegate;
    private final ExtServletContext context;
    private final String sessionId;
    private final String keyPrefix;
    private volatile boolean isInvalid = false;
    private final long created;
    private final long lastAccessed;
    private int maxTimeout;
    private final boolean isNew;
    private final HttpConfig config;

    public static boolean hasSession(String contextName, HttpSession session) {
        return session.getAttribute(ATTR_CREATED.concat(contextName)) != null;
    }

    public static Set<String> getExpiredSessionContextNames(HttpSession session) {
        long now = System.currentTimeMillis();
        HashSet<String> names = new HashSet<String>();
        Enumeration attrNames = session.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            String name = (String)attrNames.nextElement();
            if (!name.startsWith(ATTR_LAST_ACCESSED)) continue;
            String id = name.substring(ATTR_LAST_ACCESSED.length());
            long lastAccess = (Long)session.getAttribute(name);
            long maxTimeout = 1000L * (long)((Integer)session.getAttribute(ATTR_MAX_INACTIVE + id)).intValue();
            if (maxTimeout <= 0L || lastAccess + maxTimeout >= now) continue;
            names.add(id);
        }
        return names;
    }

    public static Set<String> getSessionContextNames(HttpSession session) {
        HashSet<String> names = new HashSet<String>();
        Enumeration attrNames = session.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            String name = (String)attrNames.nextElement();
            if (!name.startsWith(ATTR_LAST_ACCESSED)) continue;
            String id = name.substring(ATTR_LAST_ACCESSED.length());
            names.add(id);
        }
        return names;
    }

    public HttpSessionWrapper(HttpSession session, ExtServletContext context, HttpConfig config, boolean terminate) {
        this.config = config;
        this.delegate = session;
        this.context = context;
        this.sessionId = context.getServletContextName();
        this.keyPrefix = ATTR_PREFIX.concat(this.sessionId).concat(".");
        String createdAttrName = ATTR_CREATED.concat(this.sessionId);
        long now = System.currentTimeMillis();
        if (session.getAttribute(createdAttrName) == null) {
            this.created = now;
            this.maxTimeout = session.getMaxInactiveInterval();
            this.isNew = true;
            session.setAttribute(createdAttrName, (Object)this.created);
            session.setAttribute(ATTR_MAX_INACTIVE.concat(this.sessionId), (Object)this.maxTimeout);
            context.getHttpSessionListener().sessionCreated(new HttpSessionEvent((HttpSession)this));
        } else {
            this.created = (Long)session.getAttribute(createdAttrName);
            this.maxTimeout = (Integer)session.getAttribute(ATTR_MAX_INACTIVE.concat(this.sessionId));
            this.isNew = false;
        }
        this.lastAccessed = now;
        if (!terminate) {
            session.setAttribute(ATTR_LAST_ACCESSED.concat(this.sessionId), (Object)this.lastAccessed);
        }
    }

    private String getKey(String name) {
        return this.keyPrefix.concat(name);
    }

    private void checkInvalid() {
        if (this.isInvalid) {
            throw new IllegalStateException("Session is invalid.");
        }
    }

    public Object getAttribute(String name) {
        this.checkInvalid();
        Object result = this.delegate.getAttribute(this.getKey(name));
        if (result instanceof SessionBindingValueListenerWrapper) {
            result = ((SessionBindingValueListenerWrapper)result).getHttpSessionBindingListener();
        }
        return result;
    }

    public Enumeration<String> getAttributeNames() {
        this.checkInvalid();
        final Enumeration e = this.delegate.getAttributeNames();
        return new Enumeration<String>(){
            String next = this.peek();

            private String peek() {
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    if (!name.startsWith(HttpSessionWrapper.this.keyPrefix)) continue;
                    return name.substring(HttpSessionWrapper.this.keyPrefix.length());
                }
                return null;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next != null;
            }

            @Override
            public String nextElement() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                String result = this.next;
                this.next = this.peek();
                return result;
            }
        };
    }

    public long getCreationTime() {
        this.checkInvalid();
        return this.created;
    }

    public String getId() {
        this.checkInvalid();
        if (this.config.isUniqueSessionId()) {
            return this.delegate.getId().concat("-").concat(this.sessionId);
        }
        return this.delegate.getId();
    }

    public long getLastAccessedTime() {
        this.checkInvalid();
        return this.lastAccessed;
    }

    public int getMaxInactiveInterval() {
        return this.maxTimeout;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration<String> e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            names.add(e.nextElement());
        }
        return names.toArray(new String[names.size()]);
    }

    public void invalidate() {
        Enumeration remainingNames;
        this.checkInvalid();
        this.context.getHttpSessionListener().sessionDestroyed(new HttpSessionEvent((HttpSession)this));
        this.delegate.removeAttribute(ATTR_CREATED + this.sessionId);
        this.delegate.removeAttribute(ATTR_LAST_ACCESSED + this.sessionId);
        this.delegate.removeAttribute(ATTR_MAX_INACTIVE + this.sessionId);
        Enumeration names = this.delegate.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(this.keyPrefix)) continue;
            this.removeAttribute(name.substring(this.keyPrefix.length()));
        }
        if (this.config.isInvalidateContainerSession() && !(remainingNames = this.delegate.getAttributeNames()).hasMoreElements()) {
            this.delegate.invalidate();
        }
        this.isInvalid = true;
    }

    public boolean isNew() {
        this.checkInvalid();
        return this.isNew;
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.checkInvalid();
        Object oldValue = this.getAttribute(name);
        if (oldValue != null) {
            this.delegate.removeAttribute(this.getKey(name));
            if (oldValue instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)oldValue).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
            if (this.context.getHttpSessionAttributeListener() != null) {
                this.context.getHttpSessionAttributeListener().attributeRemoved(new HttpSessionBindingEvent((HttpSession)this, name, oldValue));
            }
        }
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.checkInvalid();
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        Object oldValue = this.getAttribute(name);
        if (value instanceof HttpSessionBindingListener) {
            this.delegate.setAttribute(this.getKey(name), (Object)new SessionBindingValueListenerWrapper((HttpSessionBindingListener)value));
        } else {
            this.delegate.setAttribute(this.getKey(name), value);
        }
        if (value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent((HttpSession)this, name));
        }
        if (this.context.getHttpSessionAttributeListener() != null) {
            if (oldValue != null) {
                this.context.getHttpSessionAttributeListener().attributeReplaced(new HttpSessionBindingEvent((HttpSession)this, name, oldValue));
            } else {
                this.context.getHttpSessionAttributeListener().attributeAdded(new HttpSessionBindingEvent((HttpSession)this, name, value));
            }
        }
    }

    public void setMaxInactiveInterval(int interval) {
        if (this.delegate.getMaxInactiveInterval() < interval) {
            this.delegate.setMaxInactiveInterval(interval);
        }
        this.maxTimeout = interval;
        this.delegate.setAttribute(ATTR_MAX_INACTIVE + this.sessionId, (Object)interval);
    }

    public HttpSessionContext getSessionContext() {
        return this.delegate.getSessionContext();
    }

    public int hashCode() {
        return this.getId().concat(this.sessionId).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HttpSessionWrapper other = (HttpSessionWrapper)obj;
        return other.getId().concat(other.sessionId).equals(this.getId().concat(this.sessionId));
    }

    private static final class SessionBindingValueListenerWrapper
    implements Serializable {
        private static final long serialVersionUID = 4009563108883768425L;
        private final HttpSessionBindingListener listener;

        public SessionBindingValueListenerWrapper(HttpSessionBindingListener listener) {
            this.listener = listener;
        }

        public HttpSessionBindingListener getHttpSessionBindingListener() {
            return this.listener;
        }
    }
}

