/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.tags.annotation.sling;

import com.thoughtworks.qdox.model.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.scr.annotations.sling.SlingFilter;
import org.apache.felix.scr.annotations.sling.SlingFilterScope;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.felix.scrplugin.tags.JavaClassDescription;
import org.apache.felix.scrplugin.tags.JavaField;
import org.apache.felix.scrplugin.tags.JavaTag;
import org.apache.felix.scrplugin.tags.annotation.AnnotationJavaClassDescription;
import org.apache.felix.scrplugin.tags.annotation.AnnotationTagProvider;
import org.apache.felix.scrplugin.tags.annotation.Util;
import org.apache.felix.scrplugin.tags.annotation.sling.SlingFilterComponentTag;
import org.apache.felix.scrplugin.tags.annotation.sling.SlingFilterServiceTag;
import org.apache.felix.scrplugin.tags.annotation.sling.SlingServletComponentTag;
import org.apache.felix.scrplugin.tags.annotation.sling.SlingServletPropertyTag;
import org.apache.felix.scrplugin.tags.annotation.sling.SlingServletServiceTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingAnnotationTagProvider
implements AnnotationTagProvider {
    public List<JavaTag> getTags(Annotation annotation, AnnotationJavaClassDescription description, JavaField field) {
        String annotationName = annotation.getType().getJavaClass().getFullyQualifiedName();
        ArrayList<JavaTag> tags = new ArrayList<JavaTag>();
        if (annotationName.equals(SlingServlet.class.getName())) {
            String[] methods;
            String[] extensions;
            String[] selectors;
            String[] resourceTypes;
            String[] paths;
            boolean generateService;
            boolean generateComponent = Util.getBooleanValue((Annotation)annotation, (String)"generateComponent", SlingServlet.class);
            if (generateComponent) {
                tags.add((JavaTag)new SlingServletComponentTag(annotation, (JavaClassDescription)description));
            }
            if (generateService = Util.getBooleanValue((Annotation)annotation, (String)"generateService", SlingServlet.class)) {
                tags.add((JavaTag)new SlingServletServiceTag(annotation, (JavaClassDescription)description));
            }
            if ((paths = Util.getStringValues((Annotation)annotation, (JavaClassDescription)description, (String)"paths")) != null && paths.length != 0) {
                tags.add((JavaTag)new SlingServletPropertyTag(annotation, "sling.servlet.paths", paths, (JavaClassDescription)description));
            }
            if ((resourceTypes = Util.getStringValues((Annotation)annotation, (JavaClassDescription)description, (String)"resourceTypes")) != null && resourceTypes.length != 0) {
                tags.add((JavaTag)new SlingServletPropertyTag(annotation, "sling.servlet.resourceTypes", resourceTypes, (JavaClassDescription)description));
            }
            if ((selectors = Util.getStringValues((Annotation)annotation, (JavaClassDescription)description, (String)"selectors")) != null && selectors.length != 0) {
                tags.add((JavaTag)new SlingServletPropertyTag(annotation, "sling.servlet.selectors", selectors, (JavaClassDescription)description));
            }
            if ((extensions = Util.getStringValues((Annotation)annotation, (JavaClassDescription)description, (String)"extensions")) != null && extensions.length != 0) {
                tags.add((JavaTag)new SlingServletPropertyTag(annotation, "sling.servlet.extensions", extensions, (JavaClassDescription)description));
            }
            if ((methods = Util.getStringValues((Annotation)annotation, (JavaClassDescription)description, (String)"methods")) != null && methods.length != 0) {
                tags.add((JavaTag)new SlingServletPropertyTag(annotation, "sling.servlet.methods", methods, (JavaClassDescription)description));
            }
        } else if (annotationName.equals(SlingFilter.class.getName())) {
            boolean generateService;
            boolean generateComponent = Util.getBooleanValue((Annotation)annotation, (String)"generateComponent", SlingFilter.class);
            if (generateComponent) {
                String desc;
                String label;
                String name = Util.getStringValue((Annotation)annotation, (JavaClassDescription)description, (String)"name", SlingFilter.class);
                if (name != null && name.trim().length() == 0) {
                    name = null;
                }
                if ((label = Util.getStringValue((Annotation)annotation, (JavaClassDescription)description, (String)"label", SlingFilter.class)) != null && label.trim().length() == 0) {
                    label = null;
                }
                if ((desc = Util.getStringValue((Annotation)annotation, (JavaClassDescription)description, (String)"description", SlingFilter.class)) != null && desc.trim().length() == 0) {
                    desc = null;
                }
                boolean createMetatype = Util.getBooleanValue((Annotation)annotation, (String)"metatype", SlingFilter.class);
                tags.add((JavaTag)new SlingFilterComponentTag(annotation, (JavaClassDescription)description, createMetatype, name, label, desc));
            }
            if (generateService = Util.getBooleanValue((Annotation)annotation, (String)"generateService", SlingFilter.class)) {
                tags.add((JavaTag)new SlingFilterServiceTag(annotation, (JavaClassDescription)description));
            }
            int order = Util.getIntValue((Annotation)annotation, (String)"order", SlingFilter.class);
            tags.add((JavaTag)new SlingServletPropertyTag(annotation, "service.ranking", String.valueOf(order), (JavaClassDescription)description, "Integer", true));
            SlingFilterScope scope = (SlingFilterScope)Util.getEnumValue((Annotation)annotation, (String)"scope", SlingFilterScope.class, SlingFilter.class);
            tags.add((JavaTag)new SlingServletPropertyTag(annotation, "sling.filter.scope", scope.getScope(), (JavaClassDescription)description, null, true));
        }
        return tags;
    }
}

