/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.apache.felix.webconsole.internal.WebConsolePluginAdapter;
import org.apache.felix.webconsole.internal.i18n.ResourceBundleManager;
import org.apache.felix.webconsole.internal.servlet.OsgiManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

class PluginHolder
implements ServiceListener {
    private final OsgiManager osgiManager;
    private final BundleContext bundleContext;
    private final Map<String, Plugin> plugins;
    private ServletContext servletContext;
    private String defaultPluginLabel;

    PluginHolder(OsgiManager osgiManager, BundleContext context) {
        this.osgiManager = osgiManager;
        this.bundleContext = context;
        this.plugins = new HashMap<String, Plugin>();
    }

    void open() {
        try {
            this.bundleContext.addServiceListener((ServiceListener)this, "(objectClass=javax.servlet.Servlet)");
        }
        catch (InvalidSyntaxException ise) {
            throw new InternalError("Failed registering for Servlet service events: " + ise.getMessage());
        }
        try {
            ServiceReference[] refs = this.bundleContext.getServiceReferences("javax.servlet.Servlet", null);
            if (refs != null) {
                for (int i = 0; i < refs.length; ++i) {
                    this.serviceAdded(refs[i]);
                }
            }
        }
        catch (InvalidSyntaxException ise) {
            throw new InternalError("Failed getting existing Servlet services: " + ise.getMessage());
        }
    }

    void close() {
        this.bundleContext.removeServiceListener((ServiceListener)this);
        Plugin[] plugin = this.getPlugins();
        for (int i = 0; i < plugin.length; ++i) {
            plugin[i].dispose();
        }
        this.plugins.clear();
        this.defaultPluginLabel = null;
    }

    String getDefaultPluginLabel() {
        return this.defaultPluginLabel;
    }

    void setDefaultPluginLabel(String defaultPluginLabel) {
        this.defaultPluginLabel = defaultPluginLabel;
    }

    void addInternalPlugin(String pluginClassName, String label) {
        InternalPlugin plugin = new InternalPlugin(this, this.osgiManager, pluginClassName, label);
        this.addPlugin(label, plugin);
    }

    void removeInternalPlugin(String label) {
        this.removePlugin(label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractWebConsolePlugin getPlugin(String label) {
        AbstractWebConsolePlugin consolePlugin = null;
        if (label != null && label.length() > 0) {
            Plugin plugin;
            Map<String, Plugin> map = this.plugins;
            synchronized (map) {
                plugin = this.plugins.get(label);
            }
            if (plugin != null) {
                consolePlugin = plugin.getConsolePlugin();
            }
        } else {
            Plugin[] plugins = this.getPlugins();
            for (int i = 0; i < plugins.length && consolePlugin == null; ++i) {
                consolePlugin = plugins[i].getConsolePlugin();
            }
        }
        return consolePlugin;
    }

    Map getLocalizedLabelMap(ResourceBundleManager resourceBundleManager, Locale locale, String defaultCategory) {
        HashMap map = new HashMap();
        HashMap<String, String> flatMap = new HashMap<String, String>();
        Plugin[] plugins = this.getPlugins();
        for (int i = 0; i < plugins.length; ++i) {
            Plugin plugin = plugins[i];
            if (!plugin.isEnabled()) continue;
            Map categoryMap = null;
            String category = plugin.getCategory();
            if (category == null || category.trim().length() == 0) {
                category = defaultCategory;
            }
            categoryMap = this.findCategoryMap(map, category);
            String label = plugin.getLabel();
            String title = plugin.getTitle();
            if (title.startsWith("%")) {
                try {
                    ResourceBundle resourceBundle = resourceBundleManager.getResourceBundle(plugin.getBundle(), locale);
                    title = resourceBundle.getString(title.substring(1));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            categoryMap.put(label, title);
            flatMap.put(label, title);
        }
        map.put("felix.webconsole.labelMap", flatMap);
        return map;
    }

    private Map findCategoryMap(Map map, String categoryPath) {
        Map categoryMap = null;
        Map searchMap = map;
        String[] categories = categoryPath.split("/");
        for (int i = 0; i < categories.length; ++i) {
            String categoryKey = "category." + categories[i];
            if (searchMap.containsKey(categoryKey)) {
                categoryMap = (Map)searchMap.get(categoryKey);
            } else {
                categoryMap = new HashMap();
                searchMap.put(categoryKey, categoryMap);
            }
            searchMap = categoryMap;
        }
        return categoryMap;
    }

    BundleContext getBundleContext() {
        return this.bundleContext;
    }

    void setServletContext(ServletContext servletContext) {
        Plugin[] plugin = this.getPlugins();
        if (servletContext != null) {
            this.servletContext = servletContext;
            for (int i = 0; i < plugin.length; ++i) {
                try {
                    plugin[i].init();
                    continue;
                }
                catch (ServletException servletException) {
                    // empty catch block
                }
            }
        } else {
            for (int i = 0; i < plugin.length; ++i) {
                try {
                    plugin[i].destroy();
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.servletContext = null;
        }
    }

    ServletContext getServletContext() {
        return this.servletContext;
    }

    public void serviceChanged(ServiceEvent event) {
        switch (event.getType()) {
            case 1: {
                this.serviceAdded(event.getServiceReference());
                break;
            }
            case 4: {
                this.serviceRemoved(event.getServiceReference());
                break;
            }
        }
    }

    private void serviceAdded(ServiceReference<?> serviceReference) {
        String label = PluginHolder.getProperty(serviceReference, "felix.webconsole.label");
        if (label != null) {
            this.addPlugin(label, new ServletPlugin(this, serviceReference, label));
        }
    }

    private void serviceRemoved(ServiceReference<?> serviceReference) {
        String label = PluginHolder.getProperty(serviceReference, "felix.webconsole.label");
        if (label != null) {
            this.removePlugin(label);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPlugin(String label, Plugin plugin) {
        Map<String, Plugin> map = this.plugins;
        synchronized (map) {
            this.plugins.compute(label, (key, oldPlugin) -> {
                if (oldPlugin != null) {
                    if (plugin.compareTo((Plugin)oldPlugin) > 0) {
                        this.osgiManager.log(2, "Overwriting existing plugin " + ((Object)((Object)oldPlugin.doGetConsolePlugin())).getClass().getName() + " having label " + key + " with new plugin " + ((Object)((Object)plugin.doGetConsolePlugin())).getClass().getName() + " due to higher ranking ");
                    } else {
                        this.osgiManager.log(2, "Ignoring new plugin " + ((Object)((Object)plugin.doGetConsolePlugin())).getClass().getName() + " having existing label " + key + " due to lower ranking than old plugin " + ((Object)((Object)oldPlugin.doGetConsolePlugin())).getClass().getName());
                        return oldPlugin;
                    }
                }
                return plugin;
            });
            this.plugins.put(label, plugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePlugin(String label) {
        Plugin oldPlugin;
        Map<String, Plugin> map = this.plugins;
        synchronized (map) {
            oldPlugin = this.plugins.remove(label);
        }
        if (oldPlugin != null) {
            oldPlugin.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Plugin[] getPlugins() {
        Map<String, Plugin> map = this.plugins;
        synchronized (map) {
            return this.plugins.values().toArray(new Plugin[this.plugins.size()]);
        }
    }

    static String getProperty(ServiceReference<?> service, String propertyName) {
        Object property = service.getProperty(propertyName);
        if (property instanceof String) {
            return (String)property;
        }
        return null;
    }

    static class InternalPlugin
    extends Plugin {
        final String pluginClassName;
        final OsgiManager osgiManager;
        AbstractWebConsolePlugin plugin;
        boolean doLog = true;

        protected InternalPlugin(PluginHolder holder, OsgiManager osgiManager, String pluginClassName, String label) {
            super(holder, null, label);
            this.osgiManager = osgiManager;
            this.pluginClassName = pluginClassName;
        }

        @Override
        protected final boolean isEnabled() {
            return !this.osgiManager.isPluginDisabled(this.pluginClassName);
        }

        @Override
        protected AbstractWebConsolePlugin doGetConsolePlugin() {
            block6: {
                if (null == this.plugin) {
                    if (!this.isEnabled()) {
                        if (this.doLog) {
                            this.osgiManager.log(3, "Ignoring plugin " + this.pluginClassName + ": Disabled by configuration");
                            this.doLog = false;
                        }
                        return null;
                    }
                    try {
                        Class<?> pluginClass = this.getClass().getClassLoader().loadClass(this.pluginClassName);
                        this.plugin = (AbstractWebConsolePlugin)((Object)pluginClass.newInstance());
                        if (this.plugin instanceof OsgiManagerPlugin) {
                            ((OsgiManagerPlugin)((Object)this.plugin)).activate(this.getBundle().getBundleContext());
                        }
                        this.doLog = true;
                    }
                    catch (Throwable t) {
                        this.plugin = null;
                        if (!this.doLog) break block6;
                        this.osgiManager.log(2, "Failed to instantiate plugin " + this.pluginClassName, t);
                        this.doLog = false;
                    }
                }
            }
            return this.plugin;
        }

        @Override
        protected void doUngetConsolePlugin(AbstractWebConsolePlugin consolePlugin) {
            if (consolePlugin == this.plugin) {
                this.plugin = null;
            }
            if (consolePlugin instanceof OsgiManagerPlugin) {
                ((OsgiManagerPlugin)((Object)consolePlugin)).deactivate();
            }
            super.doUngetConsolePlugin(consolePlugin);
        }
    }

    private static class ServletPlugin
    extends Plugin {
        ServletPlugin(PluginHolder holder, ServiceReference<?> serviceReference, String label) {
            super(holder, serviceReference, label);
        }

        @Override
        Bundle getBundle() {
            return this.serviceReference.getBundle();
        }

        @Override
        protected String doGetTitle() {
            String title = PluginHolder.getProperty(this.serviceReference, "felix.webconsole.title");
            if (title != null) {
                return title;
            }
            this.setTitle(this.getLabel());
            return super.doGetTitle();
        }

        @Override
        protected String doGetCategory() {
            String category = PluginHolder.getProperty(this.serviceReference, "felix.webconsole.category");
            if (category != null) {
                return category;
            }
            return super.doGetCategory();
        }

        @Override
        protected AbstractWebConsolePlugin doGetConsolePlugin() {
            Object service = this.getHolder().getBundleContext().getService(this.serviceReference);
            if (service instanceof Servlet) {
                AbstractWebConsolePlugin servlet = service instanceof AbstractWebConsolePlugin ? (AbstractWebConsolePlugin)((Object)service) : new WebConsolePluginAdapter(this.getLabel(), (Servlet)service, this.serviceReference);
                return servlet;
            }
            return null;
        }

        @Override
        protected void doUngetConsolePlugin(AbstractWebConsolePlugin consolePlugin) {
            this.getHolder().getBundleContext().ungetService(this.serviceReference);
        }

        @Override
        public String getInitParameter(String name) {
            Object property = this.serviceReference.getProperty(name);
            if (property != null && !property.getClass().isArray()) {
                return property.toString();
            }
            return super.getInitParameter(name);
        }

        @Override
        public Enumeration<?> getInitParameterNames() {
            final String[] keys = this.serviceReference.getPropertyKeys();
            return new Enumeration<Object>(){
                int idx = 0;

                @Override
                public boolean hasMoreElements() {
                    return this.idx < keys.length;
                }

                @Override
                public Object nextElement() {
                    if (this.hasMoreElements()) {
                        return keys[this.idx++];
                    }
                    throw new NoSuchElementException();
                }
            };
        }
    }

    private static abstract class Plugin
    implements ServletConfig,
    Comparable<Plugin> {
        private final PluginHolder holder;
        protected final ServiceReference<?> serviceReference;
        private final String label;
        private String title;

        protected Plugin(PluginHolder holder, ServiceReference<?> serviceReference, String label) {
            this.holder = holder;
            this.serviceReference = serviceReference;
            this.label = label;
        }

        void init() throws ServletException {
        }

        void destroy() {
        }

        final void dispose() {
        }

        @Override
        public int compareTo(Plugin other) {
            Integer otherRank;
            Long otherId;
            Long id = this.serviceReference != null ? (Long)this.serviceReference.getProperty("service.id") : 0L;
            if (id.equals(otherId = Long.valueOf(other.serviceReference != null ? (Long)other.serviceReference.getProperty("service.id") : 0L))) {
                return 0;
            }
            Object rankObj = this.serviceReference != null ? this.serviceReference.getProperty("service.ranking") : null;
            Object otherObj = other.serviceReference != null ? other.serviceReference.getProperty("service.ranking") : null;
            rankObj = rankObj == null ? new Integer(0) : rankObj;
            otherObj = otherObj == null ? new Integer(0) : otherObj;
            Integer rank = rankObj instanceof Integer ? (Integer)rankObj : new Integer(0);
            Integer n = otherRank = otherObj instanceof Integer ? (Integer)otherObj : new Integer(0);
            if (rank.compareTo(otherRank) < 0) {
                return -1;
            }
            if (rank.compareTo(otherRank) > 0) {
                return 1;
            }
            return id.compareTo(otherId) < 0 ? 1 : -1;
        }

        protected PluginHolder getHolder() {
            return this.holder;
        }

        Bundle getBundle() {
            return this.getHolder().getBundleContext().getBundle();
        }

        final String getLabel() {
            return this.label;
        }

        protected void setTitle(String title) {
            this.title = title;
        }

        final String getTitle() {
            if (this.title == null) {
                String title = this.doGetTitle();
                this.title = title == null ? this.getLabel() : title;
            }
            return this.title;
        }

        protected String doGetTitle() {
            AbstractWebConsolePlugin consolePlugin = this.getConsolePlugin();
            return consolePlugin != null ? consolePlugin.getTitle() : null;
        }

        final String getCategory() {
            return this.doGetCategory();
        }

        protected String doGetCategory() {
            AbstractWebConsolePlugin consolePlugin = this.getConsolePlugin();
            return consolePlugin != null ? consolePlugin.getCategory() : null;
        }

        final AbstractWebConsolePlugin getConsolePlugin() {
            AbstractWebConsolePlugin consolePlugin = this.doGetConsolePlugin();
            if (consolePlugin != null) {
                try {
                    this.init();
                }
                catch (ServletException servletException) {
                    // empty catch block
                }
            }
            return consolePlugin;
        }

        protected boolean isEnabled() {
            return true;
        }

        protected abstract AbstractWebConsolePlugin doGetConsolePlugin();

        protected void doUngetConsolePlugin(AbstractWebConsolePlugin consolePlugin) {
        }

        public String getInitParameter(String name) {
            return null;
        }

        public Enumeration<?> getInitParameterNames() {
            return new Enumeration<Object>(){

                @Override
                public boolean hasMoreElements() {
                    return false;
                }

                @Override
                public Object nextElement() {
                    throw new NoSuchElementException();
                }
            };
        }

        public ServletContext getServletContext() {
            return this.getHolder().getServletContext();
        }

        public String getServletName() {
            return this.getTitle();
        }
    }
}

