/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.configuration;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.configuration.ConfigAdminSupport;
import org.apache.felix.webconsole.internal.configuration.ConfigurationUtil;
import org.apache.felix.webconsole.internal.misc.ServletSupport;
import org.apache.felix.webconsole.spi.ConfigurationHandler;
import org.apache.felix.webconsole.spi.ValidationException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ConfigManager
extends SimpleWebConsolePlugin
implements OsgiManagerPlugin,
ServletSupport {
    private static final long serialVersionUID = 5021174538498622428L;
    private static final String LABEL = "configMgr";
    private static final String TITLE = "%configMgr.pluginTitle";
    private static final String[] CSS = new String[]{"/res/ui/config.css"};
    static final String PID_FILTER = "pidFilter";
    static final String PID = "pid";
    static final String FACTORY_PID = "factoryPid";
    static final String REFERER = "referer";
    static final String FACTORY_CREATE = "factoryCreate";
    static final String ACTION_CREATE = "create";
    static final String ACTION_DELETE = "delete";
    static final String ACTION_APPLY = "apply";
    static final String ACTION_UPDATE = "update";
    static final String ACTION_UNBIND = "unbind";
    static final String PROPERTY_LIST = "propertylist";
    static final String LOCATION = "$location";
    static final String CONFIGURATION_ADMIN_NAME = "org.osgi.service.cm.ConfigurationAdmin";
    static final String META_TYPE_NAME = "org.osgi.service.metatype.MetaTypeService";
    public static final String UNBOUND_LOCATION = "??unbound:bundle/location";
    private final String TEMPLATE = this.readTemplateFile("/templates/config.html");
    private ServiceTracker<ConfigurationHandler, ConfigurationHandler> spiTracker;

    public ConfigManager() {
        super(LABEL, TITLE, "OSGi", CSS);
    }

    @Override
    public void activate(final BundleContext bundleContext) {
        super.activate(bundleContext);
        this.spiTracker = new ServiceTracker(bundleContext, ConfigurationHandler.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ConfigurationHandler, ConfigurationHandler>(){

            public ConfigurationHandler addingService(ServiceReference<ConfigurationHandler> reference) {
                return (ConfigurationHandler)bundleContext.getService(reference);
            }

            public void modifiedService(ServiceReference<ConfigurationHandler> reference, ConfigurationHandler service) {
            }

            public void removedService(ServiceReference<ConfigurationHandler> reference, ConfigurationHandler service) {
                try {
                    bundleContext.ungetService(reference);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        });
        this.spiTracker.open(true);
    }

    @Override
    public void deactivate() {
        if (this.spiTracker != null) {
            this.spiTracker.close();
            this.spiTracker = null;
        }
        super.deactivate();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Configuration config;
        ConfigAdminSupport cas = this.getConfigurationAdminSupport();
        if (cas == null) {
            response.sendError(503);
            return;
        }
        String pid = request.getParameter(PID);
        if (pid == null) {
            String info = request.getPathInfo();
            pid = WebConsoleUtil.urlDecode(info.substring(info.lastIndexOf(47) + 1));
        }
        if (pid == null || pid.length() == 0 || !ConfigurationUtil.isAllowedPid(pid)) {
            response.sendError(400);
            return;
        }
        String pidFilter = request.getParameter(PID_FILTER);
        if (pidFilter != null && !ConfigurationUtil.isAllowedPid(pidFilter)) {
            response.sendError(400);
            return;
        }
        if (request.getParameter(ACTION_APPLY) != null) {
            if (request.getParameter(ACTION_DELETE) != null) {
                try {
                    cas.deleteConfiguration(pid);
                    Util.sendJsonOk(response);
                }
                catch (ValidationException ve) {
                    response.sendError(400, ve.getMessage());
                }
            } else {
                String propertyList = request.getParameter(PROPERTY_LIST);
                if (propertyList == null) {
                    response.sendError(400);
                    return;
                }
                try {
                    String redirect = cas.applyConfiguration(request, pid, propertyList.split(","), ACTION_UPDATE.equals(request.getParameter(ACTION_APPLY)));
                    if (pidFilter != null) {
                        redirect = redirect.concat("?").concat(PID_FILTER).concat("=").concat(pidFilter);
                    }
                    WebConsoleUtil.sendRedirect(request, response, redirect);
                }
                catch (ValidationException ve) {
                    response.sendError(400, ve.getMessage());
                }
            }
            return;
        }
        if (request.getParameter(ACTION_CREATE) != null) {
            config = ConfigurationUtil.getPlaceholderConfiguration(pid);
            pid = config.getPid();
        } else {
            config = cas.findConfiguration(pid);
        }
        if (request.getParameter(ACTION_UNBIND) != null) {
            if (config != null && config.getBundleLocation() != null) {
                config.setBundleLocation(UNBOUND_LOCATION);
            }
            Util.sendJsonOk(response);
            return;
        }
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        Locale loc = Util.getLocale(request);
        String locale = loc != null ? loc.toString() : null;
        cas.getJsonSupport().printConfigurationJson(response.getWriter(), pid, config, pidFilter, locale);
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if ("true".equals(request.getParameter("post"))) {
            this.doPost(request, response);
            return;
        }
        String info = request.getPathInfo();
        if (info.endsWith(".json")) {
            Locale loc;
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            String pid = info.substring(info.lastIndexOf(47) + 1, info.length() - 5);
            String pidFilter = request.getParameter(PID_FILTER);
            if (pidFilter == null) {
                pidFilter = pid;
            }
            try {
                this.getBundleContext().createFilter(pidFilter);
                if (pid == pidFilter) {
                    pid = null;
                }
            }
            catch (InvalidSyntaxException ise) {
                pidFilter = null;
            }
            if (pid != null && !ConfigurationUtil.isAllowedPid(pid)) {
                response.sendError(400);
            }
            if (pidFilter != null && !ConfigurationUtil.isAllowedPid(pidFilter)) {
                response.sendError(400);
            }
            String locale = (loc = Util.getLocale(request)) != null ? loc.toString() : null;
            PrintWriter pw = response.getWriter();
            pw.write("[");
            ConfigAdminSupport ca = this.getConfigurationAdminSupport();
            if (ca != null) {
                StringBuffer sb = new StringBuffer();
                if (pid != null && pidFilter != null) {
                    sb.append("(&");
                }
                if (pid != null) {
                    sb.append('(');
                    sb.append("service.pid");
                    sb.append('=');
                    sb.append(pid);
                    sb.append(')');
                }
                if (pidFilter != null) {
                    sb.append(pidFilter);
                }
                if (pid != null && pidFilter != null) {
                    sb.append(')');
                }
                String filter = sb.toString();
                try {
                    Configuration[] configs = ca.listConfigurations(filter);
                    boolean printComma = false;
                    for (int i = 0; configs != null && i < configs.length; ++i) {
                        Configuration config = configs[i];
                        if (config == null) continue;
                        if (printComma) {
                            pw.print(',');
                        }
                        ca.getJsonSupport().printConfigurationJson(pw, config.getPid(), config, null, locale);
                        printComma = true;
                    }
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            pw.write("]");
            return;
        }
        super.doGet(request, response);
    }

    @Override
    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Locale loc;
        String pid = request.getPathInfo().substring(this.getLabel().length() + 1);
        pid = pid.length() == 0 ? null : pid.substring(pid.lastIndexOf(47) + 1);
        String pidFilter = request.getParameter(PID_FILTER);
        if (pidFilter == null) {
            pidFilter = pid;
        }
        if (pidFilter != null) {
            try {
                this.getBundleContext().createFilter(pidFilter);
                if (pid == pidFilter) {
                    pid = null;
                }
            }
            catch (InvalidSyntaxException ise) {
                pidFilter = null;
            }
        }
        if (pid != null && !ConfigurationUtil.isAllowedPid(pid)) {
            response.sendError(400);
        }
        if (pidFilter != null && !ConfigurationUtil.isAllowedPid(pidFilter)) {
            response.sendError(400);
        }
        String locale = (loc = Util.getLocale(request)) != null ? loc.toString() : null;
        StringWriter json = new StringWriter();
        JSONWriter jw = new JSONWriter(json);
        jw.object();
        ConfigAdminSupport cas = this.getConfigurationAdminSupport();
        Map labelMap = (Map)request.getAttribute("felix.webconsole.labelMap");
        jw.key("jsonsupport").value(labelMap.containsKey("osgi-installer-config-printer"));
        boolean hasMetatype = cas.getMetaTypeSupport() != null;
        jw.key("status").value(cas != null ? Boolean.TRUE : Boolean.FALSE);
        jw.key("metatype").value(hasMetatype ? Boolean.TRUE : Boolean.FALSE);
        boolean hasConfigs = true;
        if (cas != null) {
            hasConfigs = cas.getJsonSupport().listConfigurations(jw, pidFilter, locale, loc);
            cas.getJsonSupport().listFactoryConfigurations(jw, pidFilter, locale);
        }
        if (!hasConfigs && !hasMetatype && cas != null) {
            jw.key("noconfigs").value(true);
        } else {
            jw.key("noconfigs").value(false);
        }
        jw.endObject();
        if (request.getParameter(ACTION_CREATE) != null && pid != null) {
            pid = ConfigurationUtil.getPlaceholderPid();
        }
        String referer = request.getParameter(REFERER);
        boolean factoryCreate = "true".equals(request.getParameter(FACTORY_CREATE));
        Map vars = (Map)((Object)WebConsoleUtil.getVariableResolver((ServletRequest)request));
        vars.put("__data__", json.toString());
        vars.put("selectedPid", pid != null ? pid : "");
        vars.put("configurationReferer", referer != null ? referer : "");
        vars.put(FACTORY_CREATE, factoryCreate);
        vars.put("param.apply", ACTION_APPLY);
        vars.put("param.create", ACTION_CREATE);
        vars.put("param.unbind", ACTION_UNBIND);
        vars.put("param.delete", ACTION_DELETE);
        vars.put("param.propertylist", PROPERTY_LIST);
        vars.put("param.pidFilter", PID_FILTER);
        response.getWriter().print(this.TEMPLATE);
    }

    private ConfigAdminSupport getConfigurationAdminSupport() {
        Object configurationAdmin = this.getService(CONFIGURATION_ADMIN_NAME);
        if (configurationAdmin != null) {
            ArrayList<ConfigurationHandler> handlers = new ArrayList<ConfigurationHandler>();
            Object[] services = this.spiTracker.getServices();
            if (services != null) {
                for (Object o : services) {
                    handlers.add((ConfigurationHandler)o);
                }
            }
            return new ConfigAdminSupport(this, configurationAdmin, handlers);
        }
        return null;
    }

    @Override
    public BundleContext getBundleContext() {
        return super.getBundleContext();
    }
}

