/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.webconsole.ConfigurationPrinter;
import org.apache.felix.webconsole.DefaultVariableResolver;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.felix.webconsole.bundleinfo.BundleInfo;
import org.apache.felix.webconsole.bundleinfo.BundleInfoProvider;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.core.BaseUpdateInstallHelper;
import org.apache.felix.webconsole.internal.core.BundleContextUtil;
import org.apache.felix.webconsole.internal.core.CapabilitiesProvidedInfoProvider;
import org.apache.felix.webconsole.internal.core.CapabilitiesRequiredInfoProvider;
import org.apache.felix.webconsole.internal.core.InstallHelper;
import org.apache.felix.webconsole.internal.core.UpdateHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class BundlesServlet
extends SimpleWebConsolePlugin
implements OsgiManagerPlugin,
ConfigurationPrinter {
    public static final String NAME = "bundles";
    private static final String TITLE = "%bundles.pluginTitle";
    private static final String[] CSS = new String[]{"/res/ui/bundles.css"};
    private static final String FILTER_PARAM = "filter";
    private static final String FIELD_STARTLEVEL = "bundlestartlevel";
    private static final String FIELD_START = "bundlestart";
    private static final String FIELD_BUNDLEFILE = "bundlefile";
    private static final String FIELD_REFRESH_PACKAGES = "refreshPackages";
    private static final String FIELD_PARALLEL_VERSION = "parallelVersion";
    private String[] bootPkgs;
    private boolean[] bootPkgWildcards;
    private ServiceRegistration<ConfigurationPrinter> configurationPrinter;
    private ServiceTracker<BundleInfoProvider, BundleInfoProvider> bundleInfoTracker;
    private final String TEMPLATE_MAIN = this.readTemplateFile("/templates/bundles.html");
    private ServiceRegistration<BundleInfoProvider> bipCapabilitiesProvided;
    private ServiceRegistration<BundleInfoProvider> bipCapabilitiesRequired;

    public BundlesServlet() {
        super(NAME, TITLE, "OSGi", CSS);
    }

    @Override
    public void activate(final BundleContext bundleContext) {
        super.activate(bundleContext);
        this.bundleInfoTracker = new ServiceTracker(bundleContext, BundleInfoProvider.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<BundleInfoProvider, BundleInfoProvider>(){

            public BundleInfoProvider addingService(ServiceReference<BundleInfoProvider> reference) {
                return (BundleInfoProvider)bundleContext.getService(reference);
            }

            public void modifiedService(ServiceReference<BundleInfoProvider> reference, BundleInfoProvider service) {
            }

            public void removedService(ServiceReference<BundleInfoProvider> reference, BundleInfoProvider service) {
                try {
                    bundleContext.ungetService(reference);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        });
        this.bundleInfoTracker.open();
        String bootDelegation = bundleContext.getProperty("org.osgi.framework.bootdelegation");
        bootDelegation = bootDelegation == null ? "java.*" : bootDelegation + ",java.*";
        StringTokenizer st = new StringTokenizer(bootDelegation, " ,");
        this.bootPkgs = new String[st.countTokens()];
        this.bootPkgWildcards = new boolean[this.bootPkgs.length];
        for (int i = 0; i < this.bootPkgs.length; ++i) {
            bootDelegation = st.nextToken();
            if (bootDelegation.endsWith("*")) {
                this.bootPkgWildcards[i] = true;
                bootDelegation = bootDelegation.substring(0, bootDelegation.length() - 1);
            }
            this.bootPkgs[i] = bootDelegation;
        }
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        props.put("felix.webconsole.configprinter.modes", new String[]{"txt", "zip"});
        this.configurationPrinter = bundleContext.registerService(ConfigurationPrinter.class, (Object)this, props);
        this.bipCapabilitiesProvided = bundleContext.registerService(BundleInfoProvider.class, (Object)new CapabilitiesProvidedInfoProvider(bundleContext.getBundle()), null);
        this.bipCapabilitiesRequired = bundleContext.registerService(BundleInfoProvider.class, (Object)new CapabilitiesRequiredInfoProvider(bundleContext.getBundle()), null);
    }

    @Override
    public void deactivate() {
        if (this.configurationPrinter != null) {
            this.configurationPrinter.unregister();
            this.configurationPrinter = null;
        }
        if (this.bundleInfoTracker != null) {
            this.bundleInfoTracker.close();
            this.bundleInfoTracker = null;
        }
        if (this.bipCapabilitiesProvided != null) {
            this.bipCapabilitiesProvided.unregister();
            this.bipCapabilitiesProvided = null;
        }
        if (this.bipCapabilitiesRequired != null) {
            this.bipCapabilitiesRequired.unregister();
            this.bipCapabilitiesRequired = null;
        }
        super.deactivate();
    }

    @Override
    public void printConfiguration(PrintWriter pw) {
        try {
            Map<String, Object> map = this.createObjectStructure(null, null, null, true, Locale.ENGLISH, null, null);
            pw.println("Status: " + map.get("status"));
            pw.println();
            Object[] data = (Object[])map.get("data");
            for (int i = 0; i < data.length; ++i) {
                Map bundle = (Map)data[i];
                pw.println(MessageFormat.format("Bundle {0} - {1} {2} (state: {3})", bundle.get("id"), bundle.get("name"), bundle.get("version"), bundle.get("state")));
                Object[] props = (Object[])bundle.get("props");
                for (int pi = 0; pi < props.length; ++pi) {
                    Map entry = (Map)props[pi];
                    String key = (String)entry.get("key");
                    if ("nfo".equals(key)) {
                        Map infos = (Map)entry.get("value");
                        for (String infoKey : infos.keySet()) {
                            pw.println("    " + infoKey + ": ");
                            Object[] infoA = (Object[])infos.get(infoKey);
                            for (int iai = 0; iai < infoA.length; ++iai) {
                                if (infoA[iai] == null) continue;
                                Map info = (Map)infoA[iai];
                                pw.println("        " + info.get("name"));
                            }
                        }
                        continue;
                    }
                    pw.print("    " + key + ": ");
                    Object entryValue = entry.get("value");
                    if (entryValue.getClass().isArray()) {
                        pw.println();
                        for (int ei = 0; ei < Array.getLength(entryValue); ++ei) {
                            Object o = Array.get(entryValue, ei);
                            if (o == null) continue;
                            pw.println("        " + o);
                        }
                        continue;
                    }
                    pw.println(entryValue);
                }
                pw.println();
            }
        }
        catch (Exception e) {
            this.log("Problem rendering Bundle details for configuration status", e);
        }
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestInfo reqInfo = new RequestInfo(request);
        if ("upload".equals(reqInfo.pathInfo)) {
            super.doGet(request, response);
            return;
        }
        if (reqInfo.bundle == null && reqInfo.bundleRequested) {
            response.sendError(404);
            return;
        }
        if (reqInfo.extension.equals("json")) {
            String pluginRoot = (String)request.getAttribute("felix.webconsole.pluginRoot");
            String servicesRoot = this.getServicesRoot(request);
            try {
                this.renderJSON(response, reqInfo.bundle, pluginRoot, servicesRoot, request.getLocale(), request.getParameter(FILTER_PARAM), null);
            }
            catch (InvalidSyntaxException e) {
                response.sendError(500, "Invalid LDAP filter specified");
            }
            return;
        }
        super.doGet(request, response);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean success = false;
        BundleException bundleException = null;
        String action = WebConsoleUtil.getParameter(req, "action");
        if (FIELD_REFRESH_PACKAGES.equals(action)) {
            FrameworkWiring fw = (FrameworkWiring)this.getBundleContext().getBundle("System Bundle").adapt(FrameworkWiring.class);
            BaseUpdateInstallHelper.refreshPackages(fw, this.getBundleContext(), 15000L, null);
            success = true;
        } else {
            if ("install".equals(action)) {
                this.installBundles(req);
                if (req.getRequestURI().endsWith("/install")) {
                    resp.setContentLength(0);
                } else {
                    resp.sendRedirect(req.getRequestURI());
                }
                return;
            }
            RequestInfo reqInfo = new RequestInfo(req);
            if (reqInfo.bundle == null && reqInfo.bundleRequested) {
                resp.sendError(404);
                return;
            }
            Bundle bundle = reqInfo.bundle;
            if (bundle != null) {
                if ("start".equals(action)) {
                    try {
                        bundle.start();
                    }
                    catch (BundleException be) {
                        bundleException = be;
                        this.log("Cannot start", be);
                    }
                } else if ("stop".equals(action)) {
                    try {
                        bundle.stop();
                    }
                    catch (BundleException be) {
                        bundleException = be;
                        this.log("Cannot stop", be);
                    }
                } else if ("refresh".equals(action)) {
                    FrameworkWiring fw = (FrameworkWiring)this.getBundleContext().getBundle("System Bundle").adapt(FrameworkWiring.class);
                    BaseUpdateInstallHelper.refreshPackages(fw, this.getBundleContext(), 5000L, bundle);
                } else if ("update".equals(action)) {
                    this.update(bundle);
                } else if ("uninstall".equals(action)) {
                    try {
                        bundle.uninstall();
                    }
                    catch (BundleException be) {
                        bundleException = be;
                        this.log("Cannot uninstall", be);
                    }
                }
                resp.setContentType("application/json");
                resp.setCharacterEncoding("UTF-8");
                if (null == this.getBundleContext()) {
                    resp.getWriter().print("false");
                } else {
                    resp.getWriter().print("{\"fragment\":" + this.isFragmentBundle(bundle) + ",\"stateRaw\":" + bundle.getState() + "}");
                }
                return;
            }
        }
        if (success && null != this.getBundleContext()) {
            String pluginRoot = (String)req.getAttribute("felix.webconsole.pluginRoot");
            String servicesRoot = this.getServicesRoot(req);
            try {
                this.renderJSON(resp, null, pluginRoot, servicesRoot, req.getLocale(), req.getParameter(FILTER_PARAM), bundleException);
            }
            catch (InvalidSyntaxException e) {
                resp.sendError(500, "Invalid LDAP filter specified");
            }
        } else {
            super.doPost(req, resp);
        }
    }

    private String getServicesRoot(HttpServletRequest request) {
        return (String)request.getAttribute("felix.webconsole.appRoot") + "/" + "services" + "/";
    }

    Bundle getBundle(String pathInfo) {
        pathInfo = pathInfo.substring(pathInfo.lastIndexOf(47) + 1);
        try {
            long bundleId = Long.parseLong(pathInfo);
            if (bundleId >= 0L) {
                return BundleContextUtil.getWorkingBundleContext(this.getBundleContext()).getBundle(bundleId);
            }
        }
        catch (NumberFormatException nfe) {
            String version;
            String symbolicName;
            int pos = pathInfo.indexOf(58);
            if (pos == -1) {
                symbolicName = pathInfo;
                version = null;
            } else {
                symbolicName = pathInfo.substring(0, pos);
                version = pathInfo.substring(pos + 1);
            }
            Bundle[] bundles = BundleContextUtil.getWorkingBundleContext(this.getBundleContext()).getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                Bundle bundle = bundles[i];
                if (!symbolicName.equals(bundle.getSymbolicName()) || version != null && !version.equals(bundle.getHeaders().get("Bundle-Version"))) continue;
                return bundle;
            }
        }
        return null;
    }

    private void appendBundleInfoCount(StringBuffer buf, String msg, int count) {
        buf.append(count);
        buf.append(" bundle");
        if (count != 1) {
            buf.append('s');
        }
        buf.append(' ');
        buf.append(msg);
    }

    @Override
    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RequestInfo reqInfo = BundlesServlet.getRequestInfo(request);
        int startLevel = this.getStartLevel().getInitialBundleStartLevel();
        DefaultVariableResolver vars = (DefaultVariableResolver)WebConsoleUtil.getVariableResolver((ServletRequest)request);
        vars.put("startLevel", String.valueOf(startLevel));
        vars.put("drawDetails", reqInfo.bundleRequested ? Boolean.TRUE : Boolean.FALSE);
        vars.put("currentBundle", reqInfo.bundleRequested && reqInfo.bundle != null ? String.valueOf(reqInfo.bundle.getBundleId()) : "null");
        String pluginRoot = (String)request.getAttribute("felix.webconsole.pluginRoot");
        String servicesRoot = this.getServicesRoot(request);
        StringWriter w = new StringWriter();
        try {
            this.writeJSON(w, reqInfo.bundle, pluginRoot, servicesRoot, request.getLocale(), request.getParameter(FILTER_PARAM), null);
        }
        catch (InvalidSyntaxException e) {
            response.sendError(500, "Invalid LDAP filter specified");
            return;
        }
        vars.put("__bundles__", w.toString());
        response.getWriter().print(this.TEMPLATE_MAIN);
    }

    private void renderJSON(HttpServletResponse response, Bundle bundle, String pluginRoot, String servicesRoot, Locale locale, String filter, BundleException be) throws IOException, InvalidSyntaxException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        PrintWriter pw = response.getWriter();
        this.writeJSON(pw, bundle, pluginRoot, servicesRoot, locale, filter, be);
    }

    private void writeJSON(Writer pw, Bundle bundle, String pluginRoot, String servicesRoot, Locale locale, String filter, BundleException be) throws IOException, InvalidSyntaxException {
        Map<String, Object> map = this.createObjectStructure(bundle, pluginRoot, servicesRoot, false, locale, filter, be);
        JSONWriter writer = new JSONWriter(pw);
        writer.value(map);
    }

    private Map<String, Object> createObjectStructure(Bundle bundle, String pluginRoot, String servicesRoot, boolean fullDetails, Locale locale, String filter, BundleException be) throws IOException, InvalidSyntaxException {
        Bundle[] bundles;
        Bundle[] allBundles = this.getBundles();
        List<Object> status = this.getStatusLine(allBundles);
        String statusLine = (String)status.remove(5);
        if (bundle != null) {
            bundles = new Bundle[]{bundle};
        } else if (filter != null) {
            Filter f = this.getBundleContext().createFilter(filter);
            ArrayList<Bundle> list = new ArrayList<Bundle>(allBundles.length);
            String localeString = locale.toString();
            int size = allBundles.length;
            for (int i = 0; i < size; ++i) {
                if (!f.match(allBundles[i].getHeaders(localeString))) continue;
                list.add(allBundles[i]);
            }
            bundles = list.toArray(new Bundle[list.size()]);
        } else {
            bundles = allBundles;
        }
        Util.sort(bundles, locale);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (null != be) {
            StringWriter s = new StringWriter();
            Throwable t = be.getNestedException() != null ? be.getNestedException() : be;
            t.printStackTrace(new PrintWriter(s));
            map.put("error", s.toString());
        }
        map.put("status", statusLine);
        map.put("s", status.toArray());
        Object[] bundlesArray = new Object[bundles.length];
        for (int i = 0; i < bundles.length; ++i) {
            bundlesArray[i] = this.bundleInfo(bundles[i], fullDetails || bundle != null, pluginRoot, servicesRoot, locale);
        }
        map.put("data", bundlesArray);
        return map;
    }

    private List<Object> getStatusLine(Bundle[] bundles) {
        ArrayList<Object> ret = new ArrayList<Object>();
        int active = 0;
        int installed = 0;
        int resolved = 0;
        int fragments = 0;
        block5: for (int i = 0; i < bundles.length; ++i) {
            switch (bundles[i].getState()) {
                case 32: {
                    ++active;
                    continue block5;
                }
                case 2: {
                    ++installed;
                    continue block5;
                }
                case 4: {
                    if (this.isFragmentBundle(bundles[i])) {
                        ++fragments;
                        continue block5;
                    }
                    ++resolved;
                }
            }
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Bundle information: ");
        this.appendBundleInfoCount(buffer, "in total", bundles.length);
        if (active == bundles.length || active + fragments == bundles.length) {
            buffer.append(" - all ");
            this.appendBundleInfoCount(buffer, "active.", bundles.length);
        } else {
            if (active != 0) {
                buffer.append(", ");
                this.appendBundleInfoCount(buffer, "active", active);
            }
            if (fragments != 0) {
                buffer.append(", ");
                this.appendBundleInfoCount(buffer, "active fragments", fragments);
            }
            if (resolved != 0) {
                buffer.append(", ");
                this.appendBundleInfoCount(buffer, "resolved", resolved);
            }
            if (installed != 0) {
                buffer.append(", ");
                this.appendBundleInfoCount(buffer, "installed", installed);
            }
            buffer.append('.');
        }
        ret.add(bundles.length);
        ret.add(active);
        ret.add(fragments);
        ret.add(resolved);
        ret.add(installed);
        ret.add(buffer.toString());
        return ret;
    }

    private Map<String, Object> bundleInfo(Bundle bundle, boolean details, String pluginRoot, String servicesRoot, Locale locale) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("id", bundle.getBundleId());
        result.put("name", Util.getName(bundle, locale));
        result.put("fragment", this.isFragmentBundle(bundle));
        result.put("stateRaw", bundle.getState());
        result.put("state", this.toStateString(bundle));
        result.put("version", Util.getHeaderValue(bundle, "Bundle-Version"));
        if (bundle.getSymbolicName() != null) {
            result.put("symbolicName", bundle.getSymbolicName());
        }
        result.put("category", Util.getHeaderValue(bundle, "Bundle-Category"));
        if (details) {
            this.bundleDetails(result, bundle, pluginRoot, servicesRoot, locale);
        }
        return result;
    }

    private final Bundle[] getBundles() {
        return BundleContextUtil.getWorkingBundleContext(this.getBundleContext()).getBundles();
    }

    private String toStateString(Bundle bundle) {
        switch (bundle.getState()) {
            case 2: {
                return "Installed";
            }
            case 4: {
                if (this.isFragmentBundle(bundle)) {
                    return "Fragment";
                }
                return "Resolved";
            }
            case 8: {
                return "Starting";
            }
            case 32: {
                return "Active";
            }
            case 16: {
                return "Stopping";
            }
            case 1: {
                return "Uninstalled";
            }
        }
        return "Unknown: " + bundle.getState();
    }

    private final boolean isFragmentBundle(Bundle bundle) {
        if (bundle.getState() == 1) {
            return bundle.getHeaders().get("Fragment-Host") != null;
        }
        return this.getPackageAdmin().getBundleType(bundle) == 1;
    }

    private void keyVal(List<Map<String, Object>> props, String key, Object val) {
        if (val != null) {
            LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
            obj.put("key", key);
            obj.put("value", val);
            props.add(obj);
        }
    }

    private final void bundleDetails(Map<String, Object> result, Bundle bundle, String pluginRoot, String servicesRoot, Locale locale) {
        Dictionary headers = bundle.getHeaders(locale == null ? null : locale.toString());
        ArrayList<Map<String, Object>> props = new ArrayList<Map<String, Object>>();
        this.keyVal(props, "Symbolic Name", bundle.getSymbolicName());
        this.keyVal(props, "Version", headers.get("Bundle-Version"));
        this.keyVal(props, "Bundle Location", bundle.getLocation());
        this.keyVal(props, "Last Modification", new Date(bundle.getLastModified()));
        String docUrl = (String)headers.get("Bundle-DocURL");
        if (docUrl != null) {
            this.keyVal(props, "Bundle Documentation", docUrl);
        }
        this.keyVal(props, "Vendor", headers.get("Bundle-Vendor"));
        this.keyVal(props, "Copyright", headers.get("Bundle-Copyright"));
        this.keyVal(props, "Description", headers.get("Bundle-Description"));
        this.keyVal(props, "Start Level", this.getStartLevel(bundle));
        this.keyVal(props, "Bundle Classpath", headers.get("Bundle-ClassPath"));
        this.listFragmentInfo(props, bundle, pluginRoot);
        if (bundle.getState() == 2) {
            this.listImportExportsUnresolved(props, bundle, pluginRoot);
        } else {
            this.listImportExport(props, bundle, pluginRoot);
        }
        if (bundle.getState() != 1) {
            this.listServices(props, bundle, servicesRoot);
        }
        this.listHeaders(props, bundle);
        String appRoot = pluginRoot == null ? "" : pluginRoot.substring(0, pluginRoot.lastIndexOf("/"));
        this.bundleInfoDetails(props, bundle, appRoot, locale);
        result.put("props", props.toArray(new Object[props.size()]));
    }

    private final void bundleInfoDetails(List<Map<String, Object>> props, Bundle bundle, String appRoot, Locale locale) {
        LinkedHashMap<String, Object> val = new LinkedHashMap<String, Object>();
        val.put("key", "nfo");
        LinkedHashMap<String, Object[]> value = new LinkedHashMap<String, Object[]>();
        Object[] bundleInfoProviders = this.bundleInfoTracker.getServices();
        for (int i = 0; bundleInfoProviders != null && i < bundleInfoProviders.length; ++i) {
            BundleInfoProvider infoProvider = (BundleInfoProvider)bundleInfoProviders[i];
            BundleInfo[] infos = infoProvider.getBundleInfo(bundle, appRoot, locale);
            if (null == infos || infos.length <= 0) continue;
            Object[] infoArray = new Object[infos.length];
            for (int j = 0; j < infos.length; ++j) {
                infoArray[j] = BundlesServlet.bundleInfo(infos[j]);
            }
            value.put(infoProvider.getName(locale), infoArray);
        }
        val.put("value", value);
        props.add(val);
    }

    private static final Map<String, Object> bundleInfo(BundleInfo info) {
        LinkedHashMap<String, Object> val = new LinkedHashMap<String, Object>();
        val.put("name", info.getName());
        val.put("description", info.getDescription());
        val.put("type", info.getType().getName());
        val.put("value", info.getValue());
        return val;
    }

    private final Integer getStartLevel(Bundle bundle) {
        StartLevel sl;
        if (bundle.getState() != 1 && (sl = this.getStartLevel()) != null) {
            return new Integer(sl.getBundleStartLevel(bundle));
        }
        return null;
    }

    private void listImportExport(List props, Bundle bundle, String pluginRoot) {
        Object[] val;
        PackageAdmin packageAdmin = this.getPackageAdmin();
        if (packageAdmin == null) {
            return;
        }
        TreeMap<String, Bundle> usingBundles = new TreeMap<String, Bundle>();
        ExportedPackage[] exports = packageAdmin.getExportedPackages(bundle);
        if (exports != null && exports.length > 0) {
            Arrays.sort(exports, new Comparator(){

                public int compare(ExportedPackage p1, ExportedPackage p2) {
                    return p1.getName().compareTo(p2.getName());
                }

                public int compare(Object o1, Object o2) {
                    return this.compare((ExportedPackage)o1, (ExportedPackage)o2);
                }
            });
            val = new Object[exports.length];
            for (int j = 0; j < exports.length; ++j) {
                ExportedPackage export = exports[j];
                val[j] = this.collectExport(export.getName(), export.getVersion());
                Bundle[] ubList = export.getImportingBundles();
                if (ubList == null) continue;
                for (int i = 0; i < ubList.length; ++i) {
                    Bundle ub = ubList[i];
                    String name = ub.getSymbolicName();
                    if (name == null) {
                        name = ub.getLocation();
                    }
                    usingBundles.put(name, ub);
                }
            }
            this.keyVal(props, "Exported Packages", val);
        } else {
            this.keyVal(props, "Exported Packages", "---");
        }
        exports = packageAdmin.getExportedPackages((Bundle)null);
        if (exports != null && exports.length > 0) {
            Object[] val2;
            ArrayList<ExportedPackage> imports = new ArrayList<ExportedPackage>();
            block2: for (int i = 0; i < exports.length; ++i) {
                ExportedPackage ep = exports[i];
                Bundle[] importers = ep.getImportingBundles();
                for (int j = 0; importers != null && j < importers.length; ++j) {
                    if (importers[j].getBundleId() != bundle.getBundleId()) continue;
                    imports.add(ep);
                    continue block2;
                }
            }
            if (imports.size() > 0) {
                ExportedPackage[] packages = imports.toArray(new ExportedPackage[imports.size()]);
                Arrays.sort(packages, new Comparator(){

                    public int compare(ExportedPackage p1, ExportedPackage p2) {
                        return p1.getName().compareTo(p2.getName());
                    }

                    public int compare(Object o1, Object o2) {
                        return this.compare((ExportedPackage)o1, (ExportedPackage)o2);
                    }
                });
                val2 = new Object[packages.length];
                for (int i = 0; i < packages.length; ++i) {
                    ExportedPackage ep = packages[i];
                    val2[i] = this.collectImport(ep.getName(), ep.getVersion(), false, ep, pluginRoot);
                }
            } else {
                val2 = new Object[]{"None"};
            }
            this.keyVal(props, "Imported Packages", val2);
        }
        if (!usingBundles.isEmpty()) {
            val = new Object[usingBundles.size()];
            int index = 0;
            for (Bundle usingBundle : usingBundles.values()) {
                val[index] = this.getBundleDescriptor(usingBundle, pluginRoot);
                ++index;
            }
            this.keyVal(props, "Importing Bundles", val);
        }
    }

    private void listImportExportsUnresolved(List props, Bundle bundle, String pluginRoot) {
        int i;
        Clause[] pkgs;
        Dictionary dict = bundle.getHeaders();
        String target = (String)dict.get("Export-Package");
        if (target != null) {
            pkgs = Parser.parseHeader(target);
            if (pkgs != null && pkgs.length > 0) {
                Arrays.sort(pkgs, new Comparator(){

                    public int compare(Clause p1, Clause p2) {
                        return p1.getName().compareTo(p2.getName());
                    }

                    public int compare(Object o1, Object o2) {
                        return this.compare((Clause)o1, (Clause)o2);
                    }
                });
                Object[] val = new Object[pkgs.length];
                for (i = 0; i < pkgs.length; ++i) {
                    Clause export = new Clause(pkgs[i].getName(), pkgs[i].getDirectives(), pkgs[i].getAttributes());
                    val[i] = this.collectExport(export.getName(), export.getAttribute("version"));
                }
                this.keyVal(props, "Exported Packages", val);
            } else {
                this.keyVal(props, "Exported Packages", "---");
            }
        }
        if ((target = (String)dict.get("Import-Package")) != null && (pkgs = Parser.parseHeader(target)) != null && pkgs.length > 0) {
            Object[] val;
            ExportedPackage[] exports;
            TreeMap<String, Clause> imports = new TreeMap<String, Clause>();
            for (i = 0; i < pkgs.length; ++i) {
                Clause pkg = pkgs[i];
                imports.put(pkg.getName(), new Clause(pkg.getName(), pkg.getDirectives(), pkg.getAttributes()));
            }
            HashMap<String, ExportedPackage> candidates = new HashMap<String, ExportedPackage>();
            PackageAdmin packageAdmin = this.getPackageAdmin();
            if (packageAdmin != null && (exports = packageAdmin.getExportedPackages((Bundle)null)) != null && exports.length > 0) {
                for (int i2 = 0; i2 < exports.length; ++i2) {
                    ExportedPackage ep = exports[i2];
                    Clause imp = (Clause)imports.get(ep.getName());
                    if (imp == null || !this.isSatisfied(imp, ep)) continue;
                    candidates.put(ep.getName(), ep);
                }
            }
            if (imports.size() > 0) {
                ArrayList<Object> importList = new ArrayList<Object>();
                for (Clause r4Import : imports.values()) {
                    String path;
                    ExportedPackage ep = (ExportedPackage)candidates.get(r4Import.getName());
                    if (ep == null && bundle.getEntry(path = r4Import.getName().replace('.', '/')) != null) continue;
                    importList.add(this.collectImport(r4Import.getName(), r4Import.getAttribute("version"), "optional".equals(r4Import.getDirective("resolution")), ep, pluginRoot));
                }
                val = importList.toArray(new Object[importList.size()]);
            } else {
                val = new Object[]{"---"};
            }
            this.keyVal(props, "Imported Packages", val);
        }
    }

    private String getServiceID(ServiceReference ref, String servicesRoot) {
        String id = ref.getProperty("service.id").toString();
        StringBuffer val = new StringBuffer();
        if (servicesRoot != null) {
            val.append("<a href='").append(servicesRoot).append(id).append("'>");
            val.append(id);
            val.append("</a>");
            return val.toString();
        }
        return id;
    }

    private void listServices(List props, Bundle bundle, String servicesRoot) {
        ServiceReference[] refs = bundle.getRegisteredServices();
        if (refs == null || refs.length == 0) {
            return;
        }
        for (int i = 0; i < refs.length; ++i) {
            String key = "Service ID " + this.getServiceID(refs[i], servicesRoot);
            ArrayList val = new ArrayList();
            this.appendProperty(val, refs[i], "objectClass", "Types");
            this.appendProperty(val, refs[i], "service.pid", "Service PID");
            this.appendProperty(val, refs[i], "org.apache.felix.karaf.features.configKey", "Feature PID");
            this.appendProperty(val, refs[i], "service.factoryPid", "Factory PID");
            this.appendProperty(val, refs[i], "component.name", "Component Name");
            this.appendProperty(val, refs[i], "component.id", "Component ID");
            this.appendProperty(val, refs[i], "component.factory", "Component Factory");
            this.appendProperty(val, refs[i], "service.description", "Description");
            this.appendProperty(val, refs[i], "service.vendor", "Vendor");
            this.keyVal(props, key, val.toArray(new Object[val.size()]));
        }
    }

    private void listHeaders(List props, Bundle bundle) {
        ArrayList<String> val = new ArrayList<String>();
        Dictionary headers = bundle.getHeaders("");
        Enumeration he = headers.keys();
        while (he.hasMoreElements()) {
            Object header = he.nextElement();
            String value = String.valueOf(headers.get(header));
            value = BundlesServlet.enableLineWrapping(value);
            val.add(header + ": " + value);
        }
        this.keyVal(props, "Manifest Headers", val.toArray(new Object[val.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String enableLineWrapping(String value) {
        StringBuffer sb;
        StringBuffer stringBuffer = sb = new StringBuffer(value.length() * 2 / 3);
        synchronized (stringBuffer) {
            for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                sb.append(ch);
                if (ch != ';' && ch != ',') continue;
                sb.append(' ');
            }
            return sb.toString();
        }
    }

    private void listFragmentInfo(List props, Bundle bundle, String pluginRoot) {
        if (this.isFragmentBundle(bundle)) {
            Bundle[] hostBundles = this.getPackageAdmin().getHosts(bundle);
            if (hostBundles != null) {
                Object[] val = new Object[hostBundles.length];
                for (int i = 0; i < hostBundles.length; ++i) {
                    val[i] = this.getBundleDescriptor(hostBundles[i], pluginRoot);
                }
                this.keyVal(props, "Host Bundles", val);
            }
        } else {
            Bundle[] fragmentBundles = this.getPackageAdmin().getFragments(bundle);
            if (fragmentBundles != null) {
                Object[] val = new Object[fragmentBundles.length];
                for (int i = 0; i < fragmentBundles.length; ++i) {
                    val[i] = this.getBundleDescriptor(fragmentBundles[i], pluginRoot);
                }
                this.keyVal(props, "Fragments Attached", val);
            }
        }
    }

    private void appendProperty(List props, ServiceReference ref, String name, String label) {
        StringBuffer dest = new StringBuffer();
        Object value = ref.getProperty(name);
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            dest.append(label).append(": ");
            for (int j = 0; j < values.length; ++j) {
                if (j > 0) {
                    dest.append(", ");
                }
                dest.append(values[j]);
            }
            props.add(dest.toString());
        } else if (value != null) {
            dest.append(label).append(": ").append(value);
            props.add(dest.toString());
        }
    }

    private Object collectExport(String name, Version version) {
        return this.collectExport(name, version == null ? null : version.toString());
    }

    private Object collectExport(String name, String version) {
        StringBuffer val = new StringBuffer();
        boolean bootDel = this.isBootDelegated(name);
        if (bootDel) {
            val.append("!! ");
        }
        val.append(name);
        if (version != null) {
            val.append(",version=").append(version);
        }
        if (bootDel) {
            val.append(" -- Overwritten by Boot Delegation");
        }
        return val.toString();
    }

    private Object collectImport(String name, Version version, boolean optional, ExportedPackage export, String pluginRoot) {
        return this.collectImport(name, version == null ? null : version.toString(), optional, export, pluginRoot);
    }

    private Object collectImport(String name, String version, boolean optional, ExportedPackage export, String pluginRoot) {
        StringBuffer val = new StringBuffer();
        boolean bootDel = this.isBootDelegated(name);
        String marker = null;
        val.append(name);
        if (version != null) {
            val.append(",version=").append(version);
        }
        if (export != null) {
            val.append(" from ");
            val.append(this.getBundleDescriptor(export.getExportingBundle(), pluginRoot));
            if (bootDel) {
                val.append(" -- Overwritten by Boot Delegation");
                marker = "INFO";
            }
        } else {
            val.append(" -- Cannot be resolved");
            marker = "ERROR";
            if (optional) {
                val.append(" but is not required");
            }
            if (bootDel) {
                val.append(" and overwritten by Boot Delegation");
            }
        }
        if (marker != null) {
            val.insert(0, ": ");
            val.insert(0, marker);
        }
        return val;
    }

    private boolean isBootDelegated(String pkgName) {
        if (pkgName.length() > 0) {
            for (int i = 0; i < this.bootPkgs.length; ++i) {
                if ((!this.bootPkgWildcards[i] || !pkgName.startsWith(this.bootPkgs[i]) && !this.bootPkgs[i].regionMatches(0, pkgName, 0, pkgName.length())) && (this.bootPkgWildcards[i] || !this.bootPkgs[i].equals(pkgName))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSatisfied(Clause imported, ExportedPackage exported) {
        if (imported.getName().equals(exported.getName())) {
            String versionAttr = imported.getAttribute("version");
            if (versionAttr == null) {
                return true;
            }
            VersionRange required = VersionRange.valueOf((String)versionAttr);
            return required.includes(exported.getVersion());
        }
        return false;
    }

    private String getBundleDescriptor(Bundle bundle, String pluginRoot) {
        StringBuffer val = new StringBuffer();
        if (pluginRoot != null) {
            val.append("<a href='").append(pluginRoot).append('/').append(bundle.getBundleId()).append("'>");
        }
        if (bundle.getSymbolicName() != null) {
            val.append(bundle.getSymbolicName());
            val.append(" (").append(bundle.getBundleId());
            val.append(")");
        } else if (bundle.getLocation() != null) {
            val.append(bundle.getLocation());
            val.append(" (").append(bundle.getBundleId());
            val.append(")");
        } else {
            val.append(bundle.getBundleId());
        }
        if (pluginRoot != null) {
            val.append("</a>");
        }
        return val.toString();
    }

    private void update(Bundle bundle) {
        UpdateHelper t = new UpdateHelper(this, bundle, false);
        t.start();
    }

    static final RequestInfo getRequestInfo(HttpServletRequest request) {
        return (RequestInfo)request.getAttribute(BundlesServlet.class.getName());
    }

    private final PackageAdmin getPackageAdmin() {
        return (PackageAdmin)this.getService(PackageAdmin.class.getName());
    }

    private final StartLevel getStartLevel() {
        return (StartLevel)this.getService(StartLevel.class.getName());
    }

    private void installBundles(HttpServletRequest request) throws IOException {
        Map params = (Map)request.getAttribute("org.apache.felix.webconsole.fileupload");
        if (params == null) {
            return;
        }
        String uidVal = WebConsoleUtil.getParameter(request, "uploadid");
        long uploadId = uidVal != null ? Long.valueOf(uidVal) : -1L;
        FileItem startItem = this.getParameter(params, FIELD_START);
        FileItem startLevelItem = this.getParameter(params, FIELD_STARTLEVEL);
        FileItem[] bundleItems = this.getFileItems(params, FIELD_BUNDLEFILE);
        FileItem refreshPackagesItem = this.getParameter(params, FIELD_REFRESH_PACKAGES);
        FileItem parallelVersionItem = this.getParameter(params, FIELD_PARALLEL_VERSION);
        if (bundleItems.length == 0) {
            return;
        }
        int startLevel = -1;
        String bundleLocation = "inputstream:";
        if (startLevelItem != null) {
            try {
                startLevel = Integer.parseInt(startLevelItem.getString());
            }
            catch (NumberFormatException nfe) {
                this.log(3, "Cannot parse start level parameter " + startLevelItem + " to a number, not setting start level");
            }
        }
        for (int i = 0; i < bundleItems.length; ++i) {
            File tmpFile;
            FileItem bundleItem;
            block8: {
                bundleItem = bundleItems[i];
                tmpFile = null;
                try {
                    tmpFile = File.createTempFile("install", ".tmp");
                    tmpFile.delete();
                    bundleItem.write(tmpFile);
                }
                catch (Exception e) {
                    this.log(1, "Problem accessing uploaded bundle file: " + bundleItem.getName(), e);
                    if (tmpFile == null) break block8;
                    tmpFile.delete();
                    tmpFile = null;
                }
            }
            if (tmpFile == null) continue;
            boolean start = startItem != null;
            boolean refreshPackages = refreshPackagesItem != null;
            boolean parallelVersion = parallelVersionItem != null;
            bundleLocation = "inputstream:" + bundleItem.getName();
            this.installBundle(bundleLocation, tmpFile, startLevel, start, refreshPackages, parallelVersion, uploadId);
        }
    }

    private FileItem getParameter(Map params, String name) {
        FileItem[] items = (FileItem[])params.get(name);
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                if (!items[i].isFormField()) continue;
                return items[i];
            }
        }
        return null;
    }

    private FileItem[] getFileItems(Map params, String name) {
        ArrayList<FileItem> files = new ArrayList<FileItem>();
        FileItem[] items = (FileItem[])params.get(name);
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                if (items[i].isFormField() || items[i].getSize() <= 0L) continue;
                files.add(items[i]);
            }
        }
        return files.toArray(new FileItem[files.size()]);
    }

    private void installBundle(String location, File bundleFile, int startLevel, boolean start, boolean refreshPackages, boolean parallelVersion, long uploadId) throws IOException {
        Map.Entry<String, String> snv = this.getSymbolicNameVersion(bundleFile);
        if (snv == null || snv.getKey() == null) {
            bundleFile.delete();
            throw new IOException("Bundle-SymbolicName header missing, cannot install bundle");
        }
        String symbolicName = snv.getKey();
        String version = snv.getValue();
        Bundle updateBundle = null;
        if ("system.bundle".equals(symbolicName)) {
            updateBundle = this.getBundleContext().getBundle(0L);
        } else if (uploadId != -1L) {
            updateBundle = BundleContextUtil.getWorkingBundleContext(this.getBundleContext()).getBundle(uploadId);
        } else {
            Bundle[] bundles = BundleContextUtil.getWorkingBundleContext(this.getBundleContext()).getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                boolean isSameVersion;
                boolean isSameBSN = bundles[i].getSymbolicName() != null && bundles[i].getSymbolicName().equals(symbolicName);
                boolean bl = isSameVersion = bundles[i].getVersion() != null && bundles[i].getVersion().equals((Object)Version.parseVersion((String)version));
                if ((bundles[i].getLocation() == null || !bundles[i].getLocation().equals(location)) && (!isSameBSN || parallelVersion && !isSameVersion)) continue;
                updateBundle = bundles[i];
                break;
            }
        }
        if (updateBundle != null) {
            this.updateBackground(updateBundle, bundleFile, refreshPackages);
        } else {
            this.installBackground(bundleFile, location, startLevel, start, refreshPackages);
        }
    }

    private String getSymbolicName(File bundleFile) {
        return this.getSymbolicNameVersion(bundleFile).getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map.Entry<String, String> getSymbolicNameVersion(File bundleFile) {
        JarFile jar = null;
        try {
            jar = new JarFile(bundleFile);
            Manifest m = jar.getManifest();
            if (m != null) {
                int paramPos;
                String sn = m.getMainAttributes().getValue("Bundle-SymbolicName");
                if (sn != null && (paramPos = sn.indexOf(59)) != -1) {
                    sn = sn.substring(0, paramPos);
                }
                String v = m.getMainAttributes().getValue("Bundle-Version");
                AbstractMap.SimpleImmutableEntry<String, String> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<String, String>(sn, v);
                return simpleImmutableEntry;
            }
        }
        catch (IOException ioe) {
            this.log(2, "Cannot extract symbolic name and version of bundle file " + bundleFile, ioe);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private void installBackground(File bundleFile, String location, int startlevel, boolean doStart, boolean refreshPackages) {
        InstallHelper t = new InstallHelper(this, this.getBundleContext(), bundleFile, location, startlevel, doStart, refreshPackages);
        t.start();
    }

    private void updateBackground(Bundle bundle, File bundleFile, boolean refreshPackages) {
        UpdateHelper t = new UpdateHelper((SimpleWebConsolePlugin)this, bundle, bundleFile, refreshPackages);
        t.start();
    }

    private final class RequestInfo {
        public final String extension;
        public final Bundle bundle;
        public final boolean bundleRequested;
        public final String pathInfo;

        protected RequestInfo(HttpServletRequest request) {
            String info = request.getPathInfo();
            info = info.substring(BundlesServlet.this.getLabel().length() + 1);
            if (info.endsWith(".json")) {
                this.extension = "json";
                info = info.substring(0, info.length() - 5);
            } else {
                this.extension = "html";
            }
            String bundleInfo = null;
            if (info.startsWith("/")) {
                bundleInfo = info.substring(1);
            }
            if (bundleInfo == null || bundleInfo.length() == 0) {
                this.bundle = null;
                this.bundleRequested = false;
                this.pathInfo = null;
            } else {
                this.bundle = BundlesServlet.this.getBundle(bundleInfo);
                this.bundleRequested = true;
                this.pathInfo = bundleInfo;
            }
            request.setAttribute(BundlesServlet.class.getName(), (Object)this);
        }
    }
}

