/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.io.File;
import java.io.InputStream;
import org.apache.felix.webconsole.internal.core.BaseUpdateInstallHelper;
import org.apache.felix.webconsole.internal.misc.ServletSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.startlevel.BundleStartLevel;

class InstallHelper
extends BaseUpdateInstallHelper {
    private final BundleContext bundleContext;
    private final String location;
    private final int startlevel;
    private final boolean doStart;

    InstallHelper(ServletSupport plugin, BundleContext bundleContext, File bundleFile, String location, int startlevel, boolean doStart, boolean refreshPackages) {
        super(plugin, "Background Install " + bundleFile, bundleFile, refreshPackages);
        this.bundleContext = bundleContext;
        this.location = location;
        this.startlevel = startlevel;
        this.doStart = doStart;
    }

    @Override
    protected Bundle doRun(InputStream bundleStream) throws BundleException {
        BundleStartLevel bsl;
        Bundle bundle = this.bundleContext.installBundle(this.location, bundleStream);
        if (this.startlevel > 0 && (bsl = (BundleStartLevel)bundle.adapt(BundleStartLevel.class)) != null) {
            bsl.setStartLevel(this.startlevel);
        }
        if (this.doStart && bundle.getHeaders().get("Fragment-Host") == null) {
            bundle.start();
        }
        return bundle;
    }
}

