/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.registry.confluent;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.formats.avro.AvroRowDataDeserializationSchema;
import org.apache.flink.formats.avro.AvroRowDataSerializationSchema;
import org.apache.flink.formats.avro.AvroToRowDataConverters;
import org.apache.flink.formats.avro.RowDataToAvroConverters;
import org.apache.flink.formats.avro.registry.confluent.AvroConfluentFormatOptions;
import org.apache.flink.formats.avro.registry.confluent.ConfluentRegistryAvroDeserializationSchema;
import org.apache.flink.formats.avro.registry.confluent.ConfluentRegistryAvroSerializationSchema;
import org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.format.ProjectableDecodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class RegistryAvroFormatFactory
implements DeserializationFormatFactory,
SerializationFormatFactory {
    public static final String IDENTIFIER = "avro-confluent";

    public DecodingFormat<DeserializationSchema<RowData>> createDecodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        final String schemaRegistryURL = (String)formatOptions.get(AvroConfluentFormatOptions.URL);
        final Optional schemaString = formatOptions.getOptional(AvroConfluentFormatOptions.SCHEMA);
        final Map<String, String> optionalPropertiesMap = RegistryAvroFormatFactory.buildOptionalPropertiesMap(formatOptions);
        return new ProjectableDecodingFormat<DeserializationSchema<RowData>>(){

            public DeserializationSchema<RowData> createRuntimeDecoder(DynamicTableSource.Context context, DataType producedDataType, int[][] projections) {
                producedDataType = Projection.of((int[][])projections).project(producedDataType);
                RowType rowType = (RowType)producedDataType.getLogicalType();
                Schema schema = schemaString.map(s -> RegistryAvroFormatFactory.getAvroSchema(s, rowType)).orElse(AvroSchemaConverter.convertToSchema((LogicalType)rowType));
                TypeInformation rowDataTypeInfo = context.createTypeInformation(producedDataType);
                return new AvroRowDataDeserializationSchema(ConfluentRegistryAvroDeserializationSchema.forGeneric(schema, schemaRegistryURL, optionalPropertiesMap), AvroToRowDataConverters.createRowConverter((RowType)rowType), rowDataTypeInfo);
            }

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.insertOnly();
            }
        };
    }

    public EncodingFormat<SerializationSchema<RowData>> createEncodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        final String schemaRegistryURL = (String)formatOptions.get(AvroConfluentFormatOptions.URL);
        final Optional subject = formatOptions.getOptional(AvroConfluentFormatOptions.SUBJECT);
        final Optional schemaString = formatOptions.getOptional(AvroConfluentFormatOptions.SCHEMA);
        final Map<String, String> optionalPropertiesMap = RegistryAvroFormatFactory.buildOptionalPropertiesMap(formatOptions);
        if (!subject.isPresent()) {
            throw new ValidationException(String.format("Option %s.%s is required for serialization", IDENTIFIER, AvroConfluentFormatOptions.SUBJECT.key()));
        }
        return new EncodingFormat<SerializationSchema<RowData>>(){

            public SerializationSchema<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType consumedDataType) {
                RowType rowType = (RowType)consumedDataType.getLogicalType();
                Schema schema = schemaString.map(s -> RegistryAvroFormatFactory.getAvroSchema(s, rowType)).orElse(AvroSchemaConverter.convertToSchema((LogicalType)rowType));
                return new AvroRowDataSerializationSchema(rowType, ConfluentRegistryAvroSerializationSchema.forGeneric((String)subject.get(), schema, schemaRegistryURL, optionalPropertiesMap), RowDataToAvroConverters.createConverter((LogicalType)rowType));
            }

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.insertOnly();
            }
        };
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(AvroConfluentFormatOptions.URL);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(AvroConfluentFormatOptions.SUBJECT);
        options.add(AvroConfluentFormatOptions.SCHEMA);
        options.add(AvroConfluentFormatOptions.PROPERTIES);
        options.add(AvroConfluentFormatOptions.SSL_KEYSTORE_LOCATION);
        options.add(AvroConfluentFormatOptions.SSL_KEYSTORE_PASSWORD);
        options.add(AvroConfluentFormatOptions.SSL_TRUSTSTORE_LOCATION);
        options.add(AvroConfluentFormatOptions.SSL_TRUSTSTORE_PASSWORD);
        options.add(AvroConfluentFormatOptions.BASIC_AUTH_CREDENTIALS_SOURCE);
        options.add(AvroConfluentFormatOptions.BASIC_AUTH_USER_INFO);
        options.add(AvroConfluentFormatOptions.BEARER_AUTH_CREDENTIALS_SOURCE);
        options.add(AvroConfluentFormatOptions.BEARER_AUTH_TOKEN);
        return options;
    }

    public Set<ConfigOption<?>> forwardOptions() {
        return Stream.of(AvroConfluentFormatOptions.URL, AvroConfluentFormatOptions.SUBJECT, AvroConfluentFormatOptions.SCHEMA, AvroConfluentFormatOptions.PROPERTIES, AvroConfluentFormatOptions.SSL_KEYSTORE_LOCATION, AvroConfluentFormatOptions.SSL_KEYSTORE_PASSWORD, AvroConfluentFormatOptions.SSL_TRUSTSTORE_LOCATION, AvroConfluentFormatOptions.SSL_TRUSTSTORE_PASSWORD, AvroConfluentFormatOptions.BASIC_AUTH_CREDENTIALS_SOURCE, AvroConfluentFormatOptions.BASIC_AUTH_USER_INFO, AvroConfluentFormatOptions.BEARER_AUTH_CREDENTIALS_SOURCE, AvroConfluentFormatOptions.BEARER_AUTH_TOKEN).collect(Collectors.toSet());
    }

    @Nullable
    public static Map<String, String> buildOptionalPropertiesMap(ReadableConfig formatOptions) {
        HashMap<String, String> properties = new HashMap<String, String>();
        formatOptions.getOptional(AvroConfluentFormatOptions.PROPERTIES).ifPresent(properties::putAll);
        formatOptions.getOptional(AvroConfluentFormatOptions.SSL_KEYSTORE_LOCATION).ifPresent(v -> properties.put("schema.registry.ssl.keystore.location", (String)v));
        formatOptions.getOptional(AvroConfluentFormatOptions.SSL_KEYSTORE_PASSWORD).ifPresent(v -> properties.put("schema.registry.ssl.keystore.password", (String)v));
        formatOptions.getOptional(AvroConfluentFormatOptions.SSL_TRUSTSTORE_LOCATION).ifPresent(v -> properties.put("schema.registry.ssl.truststore.location", (String)v));
        formatOptions.getOptional(AvroConfluentFormatOptions.SSL_TRUSTSTORE_PASSWORD).ifPresent(v -> properties.put("schema.registry.ssl.truststore.password", (String)v));
        formatOptions.getOptional(AvroConfluentFormatOptions.BASIC_AUTH_CREDENTIALS_SOURCE).ifPresent(v -> properties.put("basic.auth.credentials.source", (String)v));
        formatOptions.getOptional(AvroConfluentFormatOptions.BASIC_AUTH_USER_INFO).ifPresent(v -> properties.put("basic.auth.user.info", (String)v));
        formatOptions.getOptional(AvroConfluentFormatOptions.BEARER_AUTH_CREDENTIALS_SOURCE).ifPresent(v -> properties.put("bearer.auth.credentials.source", (String)v));
        formatOptions.getOptional(AvroConfluentFormatOptions.BEARER_AUTH_TOKEN).ifPresent(v -> properties.put("bearer.auth.token", (String)v));
        if (properties.isEmpty()) {
            return null;
        }
        return properties;
    }

    private static Schema getAvroSchema(String schemaString, RowType rowType) {
        LogicalType convertedDataType = AvroSchemaConverter.convertToDataType((String)schemaString).getLogicalType();
        if (convertedDataType.isNullable()) {
            convertedDataType = convertedDataType.copy(false);
        }
        if (!convertedDataType.equals((Object)rowType)) {
            throw new IllegalArgumentException(String.format("Schema provided for '%s' format does not match the table schema: %s", IDENTIFIER, schemaString));
        }
        return new Schema.Parser().parse(schemaString);
    }
}

