/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.java.typeutils.runtime.KryoRegistrationSerializerConfigSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.formats.avro.typeutils.AvroSerializerDebugInitHelper;
import org.apache.flink.formats.avro.utils.DataInputDecoder;
import org.apache.flink.formats.avro.utils.DataOutputEncoder;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSerializer<T>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AvroSerializer.class);
    private static final boolean CONCURRENT_ACCESS_CHECK = LOG.isDebugEnabled() || AvroSerializerDebugInitHelper.setToDebug;
    private final Class<T> type;
    private final String schemaString;
    private transient GenericDatumWriter<T> writer;
    private transient GenericDatumReader<T> reader;
    private transient DataOutputEncoder encoder;
    private transient DataInputDecoder decoder;
    private transient GenericData avroData;
    private transient Schema schema;
    private transient AvroSchemaSerializerConfigSnapshot configSnapshot;
    private volatile transient Thread currentThread;

    public AvroSerializer(Class<T> type) {
        Preconditions.checkArgument((!AvroSerializer.isGenericRecord(type) ? 1 : 0) != 0, (Object)"For GenericData.Record use constructor with explicit schema.");
        this.type = (Class)Preconditions.checkNotNull(type);
        this.schemaString = null;
    }

    public AvroSerializer(Class<T> type, Schema schema) {
        Preconditions.checkArgument((boolean)AvroSerializer.isGenericRecord(type), (Object)"For classes other than GenericData.Record use constructor without explicit schema.");
        this.type = (Class)Preconditions.checkNotNull(type);
        this.schema = (Schema)Preconditions.checkNotNull((Object)schema);
        this.schemaString = schema.toString();
    }

    @Deprecated
    public AvroSerializer(Class<T> type, Class<? extends T> typeToInstantiate) {
        this(type);
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean isImmutableType() {
        return false;
    }

    public int getLength() {
        return -1;
    }

    public T createInstance() {
        return (T)InstantiationUtil.instantiate(this.type);
    }

    public void serialize(T value, DataOutputView target) throws IOException {
        if (CONCURRENT_ACCESS_CHECK) {
            this.enterExclusiveThread();
        }
        try {
            this.checkAvroInitialized();
            this.encoder.setOut((DataOutput)target);
            this.writer.write(value, (Encoder)this.encoder);
        }
        finally {
            if (CONCURRENT_ACCESS_CHECK) {
                this.exitExclusiveThread();
            }
        }
    }

    public T deserialize(DataInputView source) throws IOException {
        if (CONCURRENT_ACCESS_CHECK) {
            this.enterExclusiveThread();
        }
        try {
            this.checkAvroInitialized();
            this.decoder.setIn((DataInput)source);
            Object object = this.reader.read(null, (Decoder)this.decoder);
            return (T)object;
        }
        finally {
            if (CONCURRENT_ACCESS_CHECK) {
                this.exitExclusiveThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T deserialize(T reuse, DataInputView source) throws IOException {
        if (CONCURRENT_ACCESS_CHECK) {
            this.enterExclusiveThread();
        }
        try {
            this.checkAvroInitialized();
            this.decoder.setIn((DataInput)source);
            Object object = this.reader.read(reuse, (Decoder)this.decoder);
            return (T)object;
        }
        finally {
            if (CONCURRENT_ACCESS_CHECK) {
                this.exitExclusiveThread();
            }
        }
    }

    public T copy(T from) {
        if (CONCURRENT_ACCESS_CHECK) {
            this.enterExclusiveThread();
        }
        try {
            this.checkAvroInitialized();
            Object object = this.avroData.deepCopy(this.schema, from);
            return (T)object;
        }
        finally {
            if (CONCURRENT_ACCESS_CHECK) {
                this.exitExclusiveThread();
            }
        }
    }

    public T copy(T from, T reuse) {
        return this.copy(from);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public TypeSerializerConfigSnapshot snapshotConfiguration() {
        if (this.configSnapshot == null) {
            this.checkAvroInitialized();
            this.configSnapshot = new AvroSchemaSerializerConfigSnapshot(this.schema.toString(false));
        }
        return this.configSnapshot;
    }

    public CompatibilityResult<T> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        if (configSnapshot instanceof AvroSchemaSerializerConfigSnapshot) {
            String schemaString = ((AvroSchemaSerializerConfigSnapshot)configSnapshot).getSchemaString();
            Schema lastSchema = new Schema.Parser().parse(schemaString);
            this.checkAvroInitialized();
            SchemaCompatibility.SchemaPairCompatibility compatibility = SchemaCompatibility.checkReaderWriterCompatibility((Schema)this.schema, (Schema)lastSchema);
            return compatibility.getType() == SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE ? CompatibilityResult.compatible() : CompatibilityResult.requiresMigration();
        }
        if (configSnapshot instanceof AvroSerializerConfigSnapshot) {
            AvroSerializerConfigSnapshot old = (AvroSerializerConfigSnapshot)configSnapshot;
            return this.type.equals(old.getTypeClass()) ? CompatibilityResult.compatible() : CompatibilityResult.requiresMigration();
        }
        return CompatibilityResult.requiresMigration();
    }

    private static boolean isGenericRecord(Class<?> type) {
        return !SpecificRecord.class.isAssignableFrom(type) && GenericRecord.class.isAssignableFrom(type);
    }

    public TypeSerializer<T> duplicate() {
        if (this.schemaString != null) {
            return new AvroSerializer<T>(this.type, this.schema);
        }
        return new AvroSerializer<T>(this.type);
    }

    public int hashCode() {
        return 42 + this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == AvroSerializer.class) {
            AvroSerializer that = (AvroSerializer)((Object)obj);
            return this.type == that.type;
        }
        return false;
    }

    public boolean canEqual(Object obj) {
        return obj.getClass() == ((Object)((Object)this)).getClass();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + " (" + this.getType().getName() + ')';
    }

    private void checkAvroInitialized() {
        if (this.writer == null) {
            this.initializeAvro();
        }
    }

    private void initializeAvro() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (SpecificRecord.class.isAssignableFrom(this.type)) {
            SpecificData specificData = new SpecificData(cl);
            this.avroData = specificData;
            this.schema = specificData.getSchema(this.type);
            this.reader = new SpecificDatumReader(this.schema, this.schema, specificData);
            this.writer = new SpecificDatumWriter(this.schema, specificData);
        } else if (GenericRecord.class.isAssignableFrom(this.type)) {
            GenericData genericData;
            if (this.schema == null) {
                this.schema = new Schema.Parser().parse(this.schemaString);
            }
            this.avroData = genericData = new GenericData(cl);
            this.reader = new GenericDatumReader(this.schema, this.schema, genericData);
            this.writer = new GenericDatumWriter(this.schema, genericData);
        } else {
            ReflectData reflectData = new ReflectData(cl);
            this.avroData = reflectData;
            this.schema = reflectData.getSchema(this.type);
            this.reader = new ReflectDatumReader(this.schema, this.schema, reflectData);
            this.writer = new ReflectDatumWriter(this.schema, reflectData);
        }
        this.encoder = new DataOutputEncoder();
        this.decoder = new DataInputDecoder();
    }

    private void enterExclusiveThread() {
        Thread previous = this.currentThread;
        Thread thisThread = Thread.currentThread();
        if (previous == null) {
            this.currentThread = thisThread;
        } else if (previous != thisThread) {
            throw new IllegalStateException("Concurrent access to KryoSerializer. Thread 1: " + thisThread.getName() + " , Thread 2: " + previous.getName());
        }
    }

    private void exitExclusiveThread() {
        this.currentThread = null;
    }

    @Deprecated
    public static class AvroSerializerConfigSnapshot<T>
    extends KryoRegistrationSerializerConfigSnapshot<T> {
        private static final int VERSION = 1;
        private Class<? extends T> typeToInstantiate;

        public void write(DataOutputView out) throws IOException {
            super.write(out);
            out.writeUTF(this.typeToInstantiate.getName());
        }

        public void read(DataInputView in) throws IOException {
            super.read(in);
            String classname = in.readUTF();
            try {
                this.typeToInstantiate = Class.forName(classname, true, this.getUserCodeClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Cannot find requested class " + classname + " in classpath.", e);
            }
        }

        public int getVersion() {
            return 1;
        }

        public Class<? extends T> getTypeToInstantiate() {
            return this.typeToInstantiate;
        }
    }

    public static final class AvroSchemaSerializerConfigSnapshot
    extends TypeSerializerConfigSnapshot {
        private String schemaString;

        public AvroSchemaSerializerConfigSnapshot() {
        }

        public AvroSchemaSerializerConfigSnapshot(String schemaString) {
            this.schemaString = (String)Preconditions.checkNotNull((Object)schemaString);
        }

        public String getSchemaString() {
            return this.schemaString;
        }

        public void read(DataInputView in) throws IOException {
            super.read(in);
            this.schemaString = in.readUTF();
        }

        public void write(DataOutputView out) throws IOException {
            super.write(out);
            out.writeUTF(this.schemaString);
        }

        public int getVersion() {
            return 1;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && obj.getClass() == AvroSchemaSerializerConfigSnapshot.class) {
                AvroSchemaSerializerConfigSnapshot that = (AvroSchemaSerializerConfigSnapshot)((Object)obj);
                return this.schemaString.equals(that.schemaString);
            }
            return false;
        }

        public int hashCode() {
            return 11 + this.schemaString.hashCode();
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getName() + " (" + this.schemaString + ')';
        }
    }
}

