/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client;

import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.client.FlinkPipelineTranslator;
import org.apache.flink.client.PlanTranslator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobGraph;

public final class FlinkPipelineTranslationUtil {
    public static JobGraph getJobGraph(Pipeline pipeline, Configuration optimizerConfiguration, int defaultParallelism) {
        FlinkPipelineTranslator pipelineTranslator = FlinkPipelineTranslationUtil.getPipelineTranslator(pipeline);
        return pipelineTranslator.translateToJobGraph(pipeline, optimizerConfiguration, defaultParallelism);
    }

    public static String translateToJSONExecutionPlan(Pipeline pipeline) {
        FlinkPipelineTranslator pipelineTranslator = FlinkPipelineTranslationUtil.getPipelineTranslator(pipeline);
        return pipelineTranslator.translateToJSONExecutionPlan(pipeline);
    }

    private static FlinkPipelineTranslator getPipelineTranslator(Pipeline pipeline) {
        PlanTranslator planToJobGraphTransmogrifier = new PlanTranslator();
        if (planToJobGraphTransmogrifier.canTranslate(pipeline)) {
            return planToJobGraphTransmogrifier;
        }
        FlinkPipelineTranslator streamGraphTranslator = FlinkPipelineTranslationUtil.reflectStreamGraphTranslator();
        if (!streamGraphTranslator.canTranslate(pipeline)) {
            throw new RuntimeException("Translator " + streamGraphTranslator + " cannot translate the given pipeline " + pipeline + ".");
        }
        return streamGraphTranslator;
    }

    private static FlinkPipelineTranslator reflectStreamGraphTranslator() {
        FlinkPipelineTranslator streamGraphTranslator;
        Class<?> streamGraphTranslatorClass;
        try {
            streamGraphTranslatorClass = Class.forName("org.apache.flink.streaming.api.graph.StreamGraphTranslator", true, FlinkPipelineTranslationUtil.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load StreamGraphTranslator.", e);
        }
        try {
            streamGraphTranslator = (FlinkPipelineTranslator)streamGraphTranslatorClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Could not instantiate StreamGraphTranslator.", e);
        }
        return streamGraphTranslator;
    }
}

