/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.client.cli.ProgramOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.WritableConfig;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.util.Preconditions;

@Internal
public class ExecutionConfigAccessor {
    private final Configuration configuration;

    private ExecutionConfigAccessor(Configuration configuration) {
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
    }

    public static ExecutionConfigAccessor fromConfiguration(Configuration configuration) {
        return new ExecutionConfigAccessor((Configuration)Preconditions.checkNotNull((Object)configuration));
    }

    public static ExecutionConfigAccessor fromProgramOptions(ProgramOptions options, List<URL> jobJars) {
        Preconditions.checkNotNull((Object)options);
        Preconditions.checkNotNull(jobJars);
        Configuration configuration = new Configuration();
        if (options.getParallelism() != -1) {
            configuration.setInteger(CoreOptions.DEFAULT_PARALLELISM, options.getParallelism());
        }
        configuration.setBoolean(DeploymentOptions.ATTACHED, !options.getDetachedMode());
        configuration.setBoolean(DeploymentOptions.SHUTDOWN_IF_ATTACHED, options.isShutdownOnAttachedExit());
        ConfigUtils.encodeCollectionToConfig((WritableConfig)configuration, (ConfigOption)PipelineOptions.CLASSPATHS, options.getClasspaths(), URL::toString);
        ConfigUtils.encodeCollectionToConfig((WritableConfig)configuration, (ConfigOption)PipelineOptions.JARS, jobJars, URL::toString);
        SavepointRestoreSettings.toConfiguration((SavepointRestoreSettings)options.getSavepointRestoreSettings(), (Configuration)configuration);
        return new ExecutionConfigAccessor(configuration);
    }

    public Configuration applyToConfiguration(Configuration baseConfiguration) {
        baseConfiguration.addAll(this.configuration);
        return baseConfiguration;
    }

    public List<URL> getJars() {
        return this.decodeUrlList(this.configuration, (ConfigOption<List<String>>)PipelineOptions.JARS);
    }

    public List<URL> getClasspaths() {
        return this.decodeUrlList(this.configuration, (ConfigOption<List<String>>)PipelineOptions.CLASSPATHS);
    }

    private List<URL> decodeUrlList(Configuration configuration, ConfigOption<List<String>> configOption) {
        return ConfigUtils.decodeListFromConfig((ReadableConfig)configuration, configOption, url -> {
            try {
                return new URL((String)url);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid URL", e);
            }
        });
    }

    public int getParallelism() {
        return this.configuration.getInteger(CoreOptions.DEFAULT_PARALLELISM);
    }

    public boolean getDetachedMode() {
        return !this.configuration.getBoolean(DeploymentOptions.ATTACHED);
    }

    public SavepointRestoreSettings getSavepointRestoreSettings() {
        return SavepointRestoreSettings.fromConfiguration((Configuration)this.configuration);
    }

    public boolean isShutdownOnAttachedExit() {
        return this.configuration.getBoolean(DeploymentOptions.SHUTDOWN_IF_ATTACHED);
    }
}

