/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.DescribedEnum;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;

@PublicEvolving
public enum DeliveryGuarantee implements DescribedEnum
{
    EXACTLY_ONCE("exactly-once", (InlineElement)TextElement.text((String)"Records are only delivered exactly-once also under failover scenarios. To build a complete exactly-once pipeline is required that the source and sink support exactly-once and are properly configured.")),
    AT_LEAST_ONCE("at-least-once", (InlineElement)TextElement.text((String)"Records are ensured to be delivered but it may happen that the same record is delivered multiple times. Usually, this guarantee is faster than the exactly-once delivery.")),
    NONE("none", (InlineElement)TextElement.text((String)"Records are delivered on a best effort basis. It is often the fastest way to process records but it may happen that records are lost or duplicated."));

    private final String name;
    private final InlineElement description;

    private DeliveryGuarantee(String name, InlineElement description) {
        this.name = name;
        this.description = description;
    }

    public InlineElement getDescription() {
        return this.description;
    }

    public String toString() {
        return this.name;
    }
}

