/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.dialect;

import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.jdbc.dialect.JdbcDialect;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public abstract class AbstractDialect
implements JdbcDialect {
    @Override
    public void validate(RowType rowType) throws ValidationException {
        for (RowType.RowField field : rowType.getFields()) {
            int precision;
            Range range;
            if (!this.supportedTypes().contains(field.getType().getTypeRoot()) || field.getType() instanceof VarBinaryType && Integer.MAX_VALUE != ((VarBinaryType)field.getType()).getLength()) {
                throw new ValidationException(String.format("The %s dialect doesn't support type: %s.", this.dialectName(), field.getType()));
            }
            if (field.getType() instanceof DecimalType) {
                range = this.decimalPrecisionRange().orElseThrow(() -> new IllegalStateException(String.format("JdbcDialect %s supports DECIMAL type but no precision range has been set. Ensure AbstractDialect#decimalPrecisionRange() is overriden to return a valid Range", this.dialectName())));
                precision = ((DecimalType)field.getType()).getPrecision();
                if (precision > range.max || precision < range.min) {
                    throw new ValidationException(String.format("The precision of field '%s' is out of the DECIMAL precision range [%d, %d] supported by %s dialect.", field.getName(), range.min, range.max, this.dialectName()));
                }
            }
            if (!(field.getType() instanceof TimestampType)) continue;
            range = this.timestampPrecisionRange().orElseThrow(() -> new IllegalStateException(String.format("JdbcDialect %s supports TIMESTAMP type but no precision range has been set.Ensure AbstractDialect#timestampPrecisionRange() is overriden to return a valid Range", this.dialectName())));
            precision = ((TimestampType)field.getType()).getPrecision();
            if (precision <= range.max && precision >= range.min) continue;
            throw new ValidationException(String.format("The precision of field '%s' is out of the TIMESTAMP precision range [%d, %d] supported by %s dialect.", field.getName(), range.min, range.max, this.dialectName()));
        }
    }

    @Override
    public String getInsertIntoStatement(String tableName, String[] fieldNames) {
        String columns = Arrays.stream(fieldNames).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String placeholders = Arrays.stream(fieldNames).map(f -> ":" + f).collect(Collectors.joining(", "));
        return "INSERT INTO " + this.quoteIdentifier(tableName) + "(" + columns + ") VALUES (" + placeholders + ")";
    }

    @Override
    public String getUpdateStatement(String tableName, String[] fieldNames, String[] conditionFields) {
        String setClause = Arrays.stream(fieldNames).map(f -> String.format("%s = :%s", this.quoteIdentifier((String)f), f)).collect(Collectors.joining(", "));
        String conditionClause = Arrays.stream(conditionFields).map(f -> String.format("%s = :%s", this.quoteIdentifier((String)f), f)).collect(Collectors.joining(" AND "));
        return "UPDATE " + this.quoteIdentifier(tableName) + " SET " + setClause + " WHERE " + conditionClause;
    }

    @Override
    public String getDeleteStatement(String tableName, String[] conditionFields) {
        String conditionClause = Arrays.stream(conditionFields).map(f -> String.format("%s = :%s", this.quoteIdentifier((String)f), f)).collect(Collectors.joining(" AND "));
        return "DELETE FROM " + this.quoteIdentifier(tableName) + " WHERE " + conditionClause;
    }

    @Override
    public String getSelectFromStatement(String tableName, String[] selectFields, String[] conditionFields) {
        String selectExpressions = Arrays.stream(selectFields).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String fieldExpressions = Arrays.stream(conditionFields).map(f -> String.format("%s = :%s", this.quoteIdentifier((String)f), f)).collect(Collectors.joining(" AND "));
        return "SELECT " + selectExpressions + " FROM " + this.quoteIdentifier(tableName) + (conditionFields.length > 0 ? " WHERE " + fieldExpressions : "");
    }

    @Override
    public String getRowExistsStatement(String tableName, String[] conditionFields) {
        String fieldExpressions = Arrays.stream(conditionFields).map(f -> String.format("%s = :%s", this.quoteIdentifier((String)f), f)).collect(Collectors.joining(" AND "));
        return "SELECT 1 FROM " + this.quoteIdentifier(tableName) + " WHERE " + fieldExpressions;
    }

    public Optional<Range> timestampPrecisionRange() {
        return Optional.empty();
    }

    public Optional<Range> decimalPrecisionRange() {
        return Optional.empty();
    }

    public abstract Set<LogicalTypeRoot> supportedTypes();

    public static class Range {
        private final int min;
        private final int max;

        public static Range of(int min, int max) {
            Preconditions.checkArgument((min <= max ? 1 : 0) != 0, (Object)String.format("The range min value in range %d must be <= max value %d", min, max));
            return new Range(min, max);
        }

        private Range(int min, int max) {
            this.min = min;
            this.max = max;
        }
    }
}

