/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.xa;

import java.io.IOException;
import java.util.ArrayList;
import javax.transaction.xa.Xid;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.connector.jdbc.xa.CheckpointAndXid;
import org.apache.flink.connector.jdbc.xa.CheckpointAndXidSerializer;
import org.apache.flink.connector.jdbc.xa.JdbcXaSinkFunctionState;
import org.apache.flink.connector.jdbc.xa.XidSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public final class XaSinkStateSerializer
extends TypeSerializer<JdbcXaSinkFunctionState> {
    private static final TypeSerializerSnapshot<JdbcXaSinkFunctionState> SNAPSHOT = new XaSinkStateSimpleXaTypeSerializerSnapshot();
    private final TypeSerializer<Xid> xidSerializer;
    private final TypeSerializer<CheckpointAndXid> checkpointAndXidSerializer;

    public XaSinkStateSerializer() {
        this(new XidSerializer(), new CheckpointAndXidSerializer());
    }

    private XaSinkStateSerializer(TypeSerializer<Xid> xidSerializer, TypeSerializer<CheckpointAndXid> checkpointAndXidSerializer) {
        this.xidSerializer = xidSerializer;
        this.checkpointAndXidSerializer = checkpointAndXidSerializer;
    }

    public boolean isImmutableType() {
        return true;
    }

    public TypeSerializer<JdbcXaSinkFunctionState> duplicate() {
        return this;
    }

    public JdbcXaSinkFunctionState createInstance() {
        return JdbcXaSinkFunctionState.empty();
    }

    public JdbcXaSinkFunctionState copy(JdbcXaSinkFunctionState from) {
        return from;
    }

    public JdbcXaSinkFunctionState copy(JdbcXaSinkFunctionState from, JdbcXaSinkFunctionState reuse) {
        return from;
    }

    public int getLength() {
        return -1;
    }

    public void serialize(JdbcXaSinkFunctionState state, DataOutputView target) throws IOException {
        target.writeInt(state.getHanging().size());
        for (Xid h : state.getHanging()) {
            this.xidSerializer.serialize((Object)h, target);
        }
        target.writeInt(state.getPrepared().size());
        for (CheckpointAndXid checkpointAndXid : state.getPrepared()) {
            this.checkpointAndXidSerializer.serialize((Object)checkpointAndXid, target);
        }
    }

    public JdbcXaSinkFunctionState deserialize(DataInputView source) throws IOException {
        int hangingSize = source.readInt();
        ArrayList<Xid> hanging = new ArrayList<Xid>(hangingSize);
        for (int i = 0; i < hangingSize; ++i) {
            hanging.add((Xid)this.xidSerializer.deserialize(source));
        }
        int preparedSize = source.readInt();
        ArrayList<CheckpointAndXid> prepared = new ArrayList<CheckpointAndXid>(preparedSize);
        for (int i = 0; i < preparedSize; ++i) {
            prepared.add((CheckpointAndXid)this.checkpointAndXidSerializer.deserialize(source));
        }
        return JdbcXaSinkFunctionState.of(prepared, hanging);
    }

    public JdbcXaSinkFunctionState deserialize(JdbcXaSinkFunctionState reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public boolean equals(Object obj) {
        return obj instanceof XaSinkStateSerializer;
    }

    public int hashCode() {
        return 0;
    }

    public TypeSerializerSnapshot<JdbcXaSinkFunctionState> snapshotConfiguration() {
        return SNAPSHOT;
    }

    public static class XaSinkStateSimpleXaTypeSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<JdbcXaSinkFunctionState> {
        private static final int VERSION = 1;

        public XaSinkStateSimpleXaTypeSerializerSnapshot() {
            super(XaSinkStateSerializer::new);
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            super.writeSnapshot(out);
            out.writeInt(1);
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader classLoader) throws IOException {
            super.readSnapshot(readVersion, in, classLoader);
            in.readInt();
        }
    }
}

