/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.lineage;

import java.util.Objects;
import java.util.Properties;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.kafka.lineage.KafkaDatasetFacet;
import org.apache.flink.connector.kafka.lineage.KafkaDatasetIdentifier;
import org.apache.flink.connector.kafka.source.KafkaPropertiesUtil;

@PublicEvolving
public class DefaultKafkaDatasetFacet
implements KafkaDatasetFacet {
    public static final String KAFKA_FACET_NAME = "kafka";
    private Properties properties;
    private final KafkaDatasetIdentifier topicIdentifier;

    public DefaultKafkaDatasetFacet(KafkaDatasetIdentifier topicIdentifier, Properties properties) {
        this(topicIdentifier);
        this.properties = new Properties();
        KafkaPropertiesUtil.copyProperties(properties, this.properties);
    }

    public DefaultKafkaDatasetFacet(KafkaDatasetIdentifier topicIdentifier) {
        this.topicIdentifier = topicIdentifier;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = new Properties();
        KafkaPropertiesUtil.copyProperties(properties, this.properties);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public KafkaDatasetIdentifier getTopicIdentifier() {
        return this.topicIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultKafkaDatasetFacet that = (DefaultKafkaDatasetFacet)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.topicIdentifier, that.topicIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.topicIdentifier);
    }

    public String name() {
        return KAFKA_FACET_NAME;
    }
}

