/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.testframe.source;

import java.util.List;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.connector.testframe.source.FromElementsSourceReader;
import org.apache.flink.connector.testframe.source.enumerator.NoOpEnumState;
import org.apache.flink.connector.testframe.source.enumerator.NoOpEnumStateSerializer;
import org.apache.flink.connector.testframe.source.enumerator.NoOpEnumerator;
import org.apache.flink.connector.testframe.source.split.FromElementsSplit;
import org.apache.flink.connector.testframe.source.split.FromElementsSplitSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.util.Preconditions;

public class FromElementsSource<OUT>
implements Source<OUT, FromElementsSplit, NoOpEnumState> {
    private Boundedness boundedness;
    private List<OUT> elements;
    private Integer emittedElementsNum;

    public FromElementsSource(List<OUT> elements) {
        this.elements = elements;
    }

    public FromElementsSource(Boundedness boundedness, List<OUT> elements, Integer emittedElementsNum) {
        this(elements);
        if (emittedElementsNum != null) {
            Preconditions.checkState((emittedElementsNum <= elements.size() ? 1 : 0) != 0, (Object)String.format("The emittedElementsNum must not be larger than the elements list %d, but actual emittedElementsNum is %d", elements.size(), emittedElementsNum));
        }
        this.boundedness = boundedness;
        this.emittedElementsNum = emittedElementsNum;
    }

    public Boundedness getBoundedness() {
        return this.boundedness == null ? Boundedness.BOUNDED : this.boundedness;
    }

    public SourceReader<OUT, FromElementsSplit> createReader(SourceReaderContext readerContext) throws Exception {
        return new FromElementsSourceReader<OUT>(this.emittedElementsNum, this.elements, this.boundedness, readerContext);
    }

    public SplitEnumerator<FromElementsSplit, NoOpEnumState> createEnumerator(SplitEnumeratorContext<FromElementsSplit> enumContext) throws Exception {
        return new NoOpEnumerator();
    }

    public SplitEnumerator<FromElementsSplit, NoOpEnumState> restoreEnumerator(SplitEnumeratorContext<FromElementsSplit> enumContext, NoOpEnumState checkpoint) throws Exception {
        return new NoOpEnumerator();
    }

    public SimpleVersionedSerializer<FromElementsSplit> getSplitSerializer() {
        return new FromElementsSplitSerializer();
    }

    public SimpleVersionedSerializer<NoOpEnumState> getEnumeratorCheckpointSerializer() {
        return new NoOpEnumStateSerializer();
    }
}

