/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.testframe.utils;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.testframe.environment.TestEnvironment;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.RestClient;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.JobVertexIdPathParameter;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.job.JobDetailsHeaders;
import org.apache.flink.runtime.rest.messages.job.JobDetailsInfo;
import org.apache.flink.runtime.rest.messages.job.metrics.AggregatedMetric;
import org.apache.flink.runtime.rest.messages.job.metrics.AggregatedMetricsResponseBody;
import org.apache.flink.runtime.rest.messages.job.metrics.AggregatedSubtaskMetricsHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.AggregatedSubtaskMetricsParameters;
import org.apache.flink.runtime.rest.messages.job.metrics.MetricsFilterParameter;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.StringUtils;
import org.assertj.core.api.AssertionsForClassTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricQuerier {
    private static final Logger LOG = LoggerFactory.getLogger(MetricQuerier.class);
    private RestClient restClient;

    public MetricQuerier(Configuration configuration) throws ConfigurationException {
        this.restClient = new RestClient(configuration, (Executor)Executors.newCachedThreadPool());
    }

    public static JobDetailsInfo getJobDetails(RestClient client, TestEnvironment.Endpoint endpoint, JobID jobId) throws Exception {
        String jmAddress = endpoint.getAddress();
        int jmPort = endpoint.getPort();
        JobMessageParameters params = new JobMessageParameters();
        params.jobPathParameter.resolve((Object)jobId);
        return (JobDetailsInfo)client.sendRequest(jmAddress, jmPort, (MessageHeaders)JobDetailsHeaders.getInstance(), (MessageParameters)params, (RequestBody)EmptyRequestBody.getInstance()).get(30L, TimeUnit.SECONDS);
    }

    public AggregatedMetricsResponseBody getMetricList(TestEnvironment.Endpoint endpoint, JobID jobId, JobVertexID vertexId) throws Exception {
        AggregatedSubtaskMetricsParameters subtaskMetricsParameters = new AggregatedSubtaskMetricsParameters();
        Iterator pathParams = subtaskMetricsParameters.getPathParameters().iterator();
        ((JobIDPathParameter)pathParams.next()).resolve((Object)jobId);
        ((JobVertexIdPathParameter)pathParams.next()).resolve((Object)vertexId);
        return (AggregatedMetricsResponseBody)this.restClient.sendRequest(endpoint.getAddress(), endpoint.getPort(), (MessageHeaders)AggregatedSubtaskMetricsHeaders.getInstance(), (MessageParameters)subtaskMetricsParameters, (RequestBody)EmptyRequestBody.getInstance()).get(30L, TimeUnit.SECONDS);
    }

    public AggregatedMetricsResponseBody getMetrics(TestEnvironment.Endpoint endpoint, JobID jobId, JobVertexID vertexId, String filters) throws Exception {
        AggregatedSubtaskMetricsParameters subtaskMetricsParameters = new AggregatedSubtaskMetricsParameters();
        Iterator pathParams = subtaskMetricsParameters.getPathParameters().iterator();
        ((JobIDPathParameter)pathParams.next()).resolve((Object)jobId);
        ((JobVertexIdPathParameter)pathParams.next()).resolve((Object)vertexId);
        MetricsFilterParameter metricFilter = (MetricsFilterParameter)subtaskMetricsParameters.getQueryParameters().iterator().next();
        metricFilter.resolveFromString(filters);
        return (AggregatedMetricsResponseBody)this.restClient.sendRequest(endpoint.getAddress(), endpoint.getPort(), (MessageHeaders)AggregatedSubtaskMetricsHeaders.getInstance(), (MessageParameters)subtaskMetricsParameters, (RequestBody)EmptyRequestBody.getInstance()).get(30L, TimeUnit.SECONDS);
    }

    public Double getAggregatedMetricsByRestAPI(TestEnvironment.Endpoint endpoint, JobID jobId, String sourceOrSinkName, String metricName, String filter) throws Exception {
        JobDetailsInfo jobDetailsInfo = MetricQuerier.getJobDetails(this.restClient, endpoint, jobId);
        JobDetailsInfo.JobVertexDetailsInfo vertex = jobDetailsInfo.getJobVertexInfos().stream().filter(v -> v.getName().contains(sourceOrSinkName)).findAny().orElse(null);
        AssertionsForClassTypes.assertThat((Object)vertex).isNotNull();
        JobVertexID vertexId = vertex.getJobVertexID();
        AggregatedMetricsResponseBody metricsResponseBody = this.getMetricList(endpoint, jobId, vertexId);
        String queryParam = metricsResponseBody.getMetrics().stream().filter(m -> this.filterByMetricName(m.getId(), sourceOrSinkName, metricName, filter)).map(m -> m.getId()).collect(Collectors.joining(","));
        if (StringUtils.isNullOrWhitespaceOnly((String)queryParam)) {
            throw new IllegalStateException(String.format("Cannot find metric[%s] for operator [%s].", metricName, sourceOrSinkName));
        }
        AggregatedMetricsResponseBody metricsResponse = this.getMetrics(endpoint, jobId, vertexId, queryParam);
        Collection metrics = metricsResponse.getMetrics();
        if (metrics == null || metrics.isEmpty()) {
            throw new IllegalStateException(String.format("Cannot find metric[%s] for operator [%s] with filter [%s].", metricName, sourceOrSinkName, filter));
        }
        return ((AggregatedMetric)metrics.iterator().next()).getSum();
    }

    private boolean filterByMetricName(String metricName, String sourceOrSinkName, String targetMetricName, @Nullable String filter) {
        boolean filterByName;
        boolean bl = filterByName = metricName.endsWith(targetMetricName) && metricName.contains(sourceOrSinkName);
        if (!StringUtils.isNullOrWhitespaceOnly((String)filter)) {
            return filterByName && metricName.contains(filter);
        }
        return filterByName;
    }
}

