/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.operators;

import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.state.OperatorStateStore;
import org.apache.flink.datastream.api.context.NonPartitionedContext;
import org.apache.flink.datastream.api.context.PartitionedContext;
import org.apache.flink.datastream.api.context.ProcessingTimeManager;
import org.apache.flink.datastream.api.function.TwoInputBroadcastStreamProcessFunction;
import org.apache.flink.datastream.impl.common.OutputCollector;
import org.apache.flink.datastream.impl.common.TimestampCollector;
import org.apache.flink.datastream.impl.context.DefaultNonPartitionedContext;
import org.apache.flink.datastream.impl.context.DefaultPartitionedContext;
import org.apache.flink.datastream.impl.context.DefaultRuntimeContext;
import org.apache.flink.datastream.impl.context.UnsupportedProcessingTimeManager;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedMultiInput;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Preconditions;

public class TwoInputBroadcastProcessOperator<IN1, IN2, OUT>
extends AbstractUdfStreamOperator<OUT, TwoInputBroadcastStreamProcessFunction<IN1, IN2, OUT>>
implements TwoInputStreamOperator<IN1, IN2, OUT>,
BoundedMultiInput {
    protected transient TimestampCollector<OUT> collector;
    protected transient DefaultRuntimeContext context;
    protected transient DefaultPartitionedContext partitionedContext;
    protected transient NonPartitionedContext<OUT> nonPartitionedContext;

    public TwoInputBroadcastProcessOperator(TwoInputBroadcastStreamProcessFunction<IN1, IN2, OUT> userFunction) {
        super(userFunction);
        this.chainingStrategy = ChainingStrategy.ALWAYS;
    }

    public void open() throws Exception {
        super.open();
        this.collector = this.getOutputCollector();
        StreamingRuntimeContext operatorContext = this.getRuntimeContext();
        TaskInfo taskInfo = operatorContext.getTaskInfo();
        this.context = new DefaultRuntimeContext(operatorContext.getJobInfo().getJobName(), operatorContext.getJobType(), taskInfo.getNumberOfParallelSubtasks(), taskInfo.getMaxNumberOfParallelSubtasks(), taskInfo.getTaskName(), (MetricGroup)operatorContext.getMetricGroup());
        this.partitionedContext = new DefaultPartitionedContext(this.context, this::currentKey, arg_0 -> ((TwoInputBroadcastProcessOperator)this).setCurrentKey(arg_0), this.getProcessingTimeManager(), operatorContext, (OperatorStateStore)this.getOperatorStateBackend());
        this.nonPartitionedContext = this.getNonPartitionedContext();
    }

    public void processElement1(StreamRecord<IN1> element) throws Exception {
        this.collector.setTimestampFromStreamRecord(element);
        ((TwoInputBroadcastStreamProcessFunction)this.userFunction).processRecordFromNonBroadcastInput(element.getValue(), this.collector, (PartitionedContext)this.partitionedContext);
    }

    public void processElement2(StreamRecord<IN2> element) throws Exception {
        this.collector.setTimestampFromStreamRecord(element);
        ((TwoInputBroadcastStreamProcessFunction)this.userFunction).processRecordFromBroadcastInput(element.getValue(), this.nonPartitionedContext);
    }

    protected TimestampCollector<OUT> getOutputCollector() {
        return new OutputCollector(this.output);
    }

    protected NonPartitionedContext<OUT> getNonPartitionedContext() {
        return new DefaultNonPartitionedContext<OUT>(this.context, this.partitionedContext, this.collector, false, null);
    }

    public void endInput(int inputId) throws Exception {
        Preconditions.checkState((inputId >= 1 && inputId <= 2 ? 1 : 0) != 0);
        if (inputId == 1) {
            ((TwoInputBroadcastStreamProcessFunction)this.userFunction).endNonBroadcastInput(this.nonPartitionedContext);
        } else {
            ((TwoInputBroadcastStreamProcessFunction)this.userFunction).endBroadcastInput(this.nonPartitionedContext);
        }
    }

    protected Object currentKey() {
        throw new UnsupportedOperationException("The key is only defined for keyed operator");
    }

    protected ProcessingTimeManager getProcessingTimeManager() {
        return UnsupportedProcessingTimeManager.INSTANCE;
    }
}

