/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.BulkPartWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputStreamBasedPartFileWriter;
import org.apache.flink.util.Preconditions;

@Internal
public class BulkBucketWriter<IN, BucketID>
extends OutputStreamBasedPartFileWriter.OutputStreamBasedBucketWriter<IN, BucketID> {
    private final BulkWriter.Factory<IN> writerFactory;

    public BulkBucketWriter(RecoverableWriter recoverableWriter, BulkWriter.Factory<IN> writerFactory) throws IOException {
        super(recoverableWriter);
        this.writerFactory = writerFactory;
    }

    @Override
    public InProgressFileWriter<IN, BucketID> resumeFrom(BucketID bucketId, RecoverableFsDataOutputStream stream, RecoverableWriter.ResumeRecoverable resumable, long creationTime) throws IOException {
        Preconditions.checkNotNull((Object)stream);
        Preconditions.checkNotNull((Object)resumable);
        BulkWriter writer = this.writerFactory.create((FSDataOutputStream)stream);
        return new BulkPartWriter(bucketId, stream, writer, creationTime);
    }

    @Override
    public InProgressFileWriter<IN, BucketID> openNew(BucketID bucketId, RecoverableFsDataOutputStream stream, Path path, long creationTime) throws IOException {
        Preconditions.checkNotNull((Object)stream);
        Preconditions.checkNotNull((Object)path);
        BulkWriter writer = this.writerFactory.create((FSDataOutputStream)stream);
        return new BulkPartWriter(bucketId, stream, writer, creationTime);
    }
}

