/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketHandshakeException;
import io.fabric8.kubernetes.client.utils.InputStreamPumper;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecWebSocketListener
implements ExecWatch,
AutoCloseable,
WebSocket.Listener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecWebSocketListener.class);
    private static final String HEIGHT = "Height";
    private static final String WIDTH = "Width";
    private final InputStream in;
    private final OutputStream out;
    private final OutputStream err;
    private final OutputStream errChannel;
    private final PipedOutputStream input;
    private final PipedInputStream output;
    private final PipedInputStream error;
    private final PipedInputStream errorChannel;
    private final AtomicReference<WebSocket> webSocketRef = new AtomicReference();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final ExecListener listener;
    private final AtomicBoolean explicitlyClosed = new AtomicBoolean(false);
    private final AtomicBoolean failed = new AtomicBoolean(false);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean cleaned = new AtomicBoolean(false);
    private final Set<Closeable> toClose = new LinkedHashSet<Closeable>();
    private ObjectMapper objectMapper;

    public ExecWebSocketListener(InputStream in, OutputStream out, OutputStream err, OutputStream errChannel, PipedOutputStream inputPipe, PipedInputStream outputPipe, PipedInputStream errorPipe, PipedInputStream errorChannelPipe, ExecListener listener, Integer bufferSize) {
        this.listener = listener;
        this.in = ExecWebSocketListener.inputStreamOrPipe(in, inputPipe, this.toClose, bufferSize);
        this.out = ExecWebSocketListener.outputStreamOrPipe(out, outputPipe, this.toClose);
        this.err = ExecWebSocketListener.outputStreamOrPipe(err, errorPipe, this.toClose);
        this.errChannel = ExecWebSocketListener.outputStreamOrPipe(errChannel, errorChannelPipe, this.toClose);
        this.input = inputPipe;
        this.output = outputPipe;
        this.error = errorPipe;
        this.errorChannel = errorChannelPipe;
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public void close() {
        this.close(1000, "Closing...");
    }

    public void close(int code, String reason) {
        this.explicitlyClosed.set(true);
        this.closeWebSocketOnce(code, reason);
        this.onClosed(code, reason);
    }

    private void cleanUpOnce() {
        if (!this.cleaned.compareAndSet(false, true)) {
            return;
        }
        this.executorService.shutdownNow();
        Utils.closeQuietly(this.toClose);
    }

    private void closeWebSocketOnce(int code, String reason) {
        if (this.closed.get()) {
            return;
        }
        try {
            WebSocket ws = this.webSocketRef.get();
            if (ws != null) {
                ws.sendClose(code, reason);
            }
        }
        catch (Throwable t) {
            LOGGER.debug("Error closing WebSocket.", t);
        }
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        try {
            if (this.in instanceof PipedInputStream && this.input != null) {
                this.input.connect((PipedInputStream)this.in);
            }
            if (this.out instanceof PipedOutputStream && this.output != null) {
                this.output.connect((PipedOutputStream)this.out);
            }
            if (this.err instanceof PipedOutputStream && this.error != null) {
                this.error.connect((PipedOutputStream)this.err);
            }
            if (this.errChannel instanceof PipedOutputStream && this.errorChannel != null) {
                this.errorChannel.connect((PipedOutputStream)this.errChannel);
            }
            this.webSocketRef.set(webSocket);
            if (this.in != null && !this.executorService.isShutdown()) {
                InputStreamPumper.pump(InputStreamPumper.asInterruptible(this.in), this::send, this.executorService);
            }
        }
        catch (IOException e) {
            this.onError(webSocket, e);
        }
        finally {
            if (this.listener != null) {
                this.listener.onOpen();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(WebSocket webSocket, Throwable t) {
        if (this.explicitlyClosed.get() || this.closed.get() || !this.failed.compareAndSet(false, true)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Received [{}], with message:[{}] after ExecWebSocketListener is closed, Ignoring.", (Object)t.getClass().getCanonicalName(), (Object)t.getMessage());
            }
            return;
        }
        HttpResponse<?> response = null;
        try {
            if (t instanceof WebSocketHandshakeException) {
                response = ((WebSocketHandshakeException)t).getResponse();
            }
            Status status = OperationSupport.createStatus(response);
            status.setMessage(t.getMessage());
            LOGGER.error("Exec Failure", t);
            this.cleanUpOnce();
        }
        finally {
            if (this.listener != null) {
                SimpleResponse execResponse = null;
                if (response != null) {
                    execResponse = new SimpleResponse(response);
                }
                this.listener.onFailure(t, execResponse);
            }
        }
    }

    @Override
    public void onMessage(WebSocket webSocket, ByteBuffer bytes) {
        block10: {
            try {
                byte streamID = bytes.get(0);
                bytes.position(1);
                ByteBuffer byteString = bytes.slice();
                if (byteString.remaining() <= 0) break block10;
                switch (streamID) {
                    case 1: {
                        if (this.out != null) {
                            Channels.newChannel(this.out).write(byteString);
                            this.out.flush();
                        }
                        break;
                    }
                    case 2: {
                        if (this.err != null) {
                            Channels.newChannel(this.err).write(byteString);
                        }
                        break;
                    }
                    case 3: {
                        if (this.errChannel != null) {
                            Channels.newChannel(this.errChannel).write(byteString);
                        }
                        break;
                    }
                    default: {
                        throw new IOException("Unknown stream ID " + streamID);
                    }
                }
            }
            catch (IOException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }
    }

    @Override
    public void onClose(WebSocket webSocket, int code, String reason) {
        this.close(code, reason);
    }

    private void onClosed(int code, String reason) {
        if (!this.closed.compareAndSet(false, true) || this.failed.get()) {
            return;
        }
        LOGGER.debug("Exec Web Socket: On Close with code:[{}], due to: [{}]", (Object)code, (Object)reason);
        try {
            if (this.explicitlyClosed.get()) {
                this.cleanUpOnce();
            }
        }
        finally {
            if (this.listener != null) {
                this.listener.onClose(code, reason);
            }
        }
    }

    @Override
    public OutputStream getInput() {
        return this.input;
    }

    @Override
    public InputStream getOutput() {
        return this.output;
    }

    @Override
    public InputStream getError() {
        return this.error;
    }

    @Override
    public InputStream getErrorChannel() {
        return this.errorChannel;
    }

    @Override
    public void resize(int cols, int rows) {
        if (cols < 0 || rows < 0) {
            return;
        }
        try {
            HashMap<String, Integer> map = new HashMap<String, Integer>(4);
            map.put(HEIGHT, rows);
            map.put(WIDTH, cols);
            byte[] bytes = this.objectMapper.writeValueAsBytes(map);
            this.send(bytes, 0, bytes.length, (byte)4);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private void send(byte[] bytes, int offset, int length, byte flag) {
        WebSocket ws;
        if (length > 0 && (ws = this.webSocketRef.get()) != null) {
            byte[] toSend = new byte[length + 1];
            toSend[0] = flag;
            System.arraycopy(bytes, offset, toSend, 1, length);
            ws.send(ByteBuffer.wrap(toSend));
        }
    }

    private void send(byte[] bytes, int offset, int length) {
        this.send(bytes, offset, length, (byte)0);
    }

    private static InputStream inputStreamOrPipe(InputStream stream, PipedOutputStream out, Set<Closeable> toClose, Integer bufferSize) {
        if (stream != null) {
            return stream;
        }
        if (out != null) {
            PipedInputStream pis = bufferSize == null ? new PipedInputStream() : new PipedInputStream(bufferSize);
            toClose.add(pis);
            return pis;
        }
        return null;
    }

    private static OutputStream outputStreamOrPipe(OutputStream stream, PipedInputStream in, Set<Closeable> toClose) {
        if (stream != null) {
            return stream;
        }
        if (in != null) {
            PipedOutputStream pos = new PipedOutputStream();
            toClose.add(pos);
            return pos;
        }
        return null;
    }

    private final class SimpleResponse
    implements ExecListener.Response {
        private final HttpResponse<?> response;

        private SimpleResponse(HttpResponse<?> response) {
            this.response = response;
        }

        @Override
        public int code() {
            return this.response.code();
        }

        @Override
        public String body() throws IOException {
            return this.response.bodyString();
        }
    }
}

