/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.highavailability;

import java.util.concurrent.Executor;
import org.apache.flink.kubernetes.configuration.KubernetesLeaderElectionConfiguration;
import org.apache.flink.kubernetes.highavailability.KubernetesMultipleComponentLeaderElectionDriver;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClient;
import org.apache.flink.kubernetes.kubeclient.KubernetesConfigMapSharedWatcher;
import org.apache.flink.runtime.leaderelection.MultipleComponentLeaderElectionDriver;
import org.apache.flink.runtime.leaderelection.MultipleComponentLeaderElectionDriverFactory;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.util.Preconditions;

public class KubernetesMultipleComponentLeaderElectionDriverFactory
implements MultipleComponentLeaderElectionDriverFactory {
    private final FlinkKubeClient kubeClient;
    private final KubernetesLeaderElectionConfiguration kubernetesLeaderElectionConfiguration;
    private final KubernetesConfigMapSharedWatcher configMapSharedWatcher;
    private final Executor watchExecutor;
    private final FatalErrorHandler fatalErrorHandler;

    public KubernetesMultipleComponentLeaderElectionDriverFactory(FlinkKubeClient kubeClient, KubernetesLeaderElectionConfiguration kubernetesLeaderElectionConfiguration, KubernetesConfigMapSharedWatcher configMapSharedWatcher, Executor watchExecutor, FatalErrorHandler fatalErrorHandler) {
        this.kubeClient = (FlinkKubeClient)Preconditions.checkNotNull((Object)kubeClient);
        this.kubernetesLeaderElectionConfiguration = (KubernetesLeaderElectionConfiguration)Preconditions.checkNotNull((Object)kubernetesLeaderElectionConfiguration);
        this.configMapSharedWatcher = (KubernetesConfigMapSharedWatcher)Preconditions.checkNotNull((Object)configMapSharedWatcher);
        this.watchExecutor = (Executor)Preconditions.checkNotNull((Object)watchExecutor);
        this.fatalErrorHandler = (FatalErrorHandler)Preconditions.checkNotNull((Object)fatalErrorHandler);
    }

    public KubernetesMultipleComponentLeaderElectionDriver create(MultipleComponentLeaderElectionDriver.Listener leaderElectionListener) throws Exception {
        return new KubernetesMultipleComponentLeaderElectionDriver(this.kubernetesLeaderElectionConfiguration, this.kubeClient, leaderElectionListener, this.configMapSharedWatcher, this.watchExecutor, this.fatalErrorHandler);
    }
}

