/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.client.state.serialization;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;

public final class KvStateSerializer {
    public static <K, N> byte[] serializeKeyAndNamespace(K key, TypeSerializer<K> keySerializer, N namespace, TypeSerializer<N> namespaceSerializer) throws IOException {
        DataOutputSerializer dos = new DataOutputSerializer(32);
        keySerializer.serialize(key, (DataOutputView)dos);
        dos.writeByte(42);
        namespaceSerializer.serialize(namespace, (DataOutputView)dos);
        return dos.getCopyOfBuffer();
    }

    public static <K, N> Tuple2<K, N> deserializeKeyAndNamespace(byte[] serializedKeyAndNamespace, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer) throws IOException {
        DataInputDeserializer dis = new DataInputDeserializer(serializedKeyAndNamespace, 0, serializedKeyAndNamespace.length);
        try {
            Object key = keySerializer.deserialize((DataInputView)dis);
            byte magicNumber = dis.readByte();
            if (magicNumber != 42) {
                throw new IOException("Unexpected magic number " + magicNumber + ".");
            }
            Object namespace = namespaceSerializer.deserialize((DataInputView)dis);
            if (dis.available() > 0) {
                throw new IOException("Unconsumed bytes in the serialized key and namespace.");
            }
            return new Tuple2(key, namespace);
        }
        catch (IOException e) {
            throw new IOException("Unable to deserialize key and namespace. This indicates a mismatch in the key/namespace serializers used by the KvState instance and this access.", e);
        }
    }

    public static <T> byte[] serializeValue(T value, TypeSerializer<T> serializer) throws IOException {
        if (value != null) {
            DataOutputSerializer dos = new DataOutputSerializer(32);
            serializer.serialize(value, (DataOutputView)dos);
            return dos.getCopyOfBuffer();
        }
        return null;
    }

    public static <T> T deserializeValue(byte[] serializedValue, TypeSerializer<T> serializer) throws IOException {
        if (serializedValue == null) {
            return null;
        }
        DataInputDeserializer deser = new DataInputDeserializer(serializedValue, 0, serializedValue.length);
        Object value = serializer.deserialize((DataInputView)deser);
        if (deser.available() > 0) {
            throw new IOException("Unconsumed bytes in the deserialized value. This indicates a mismatch in the value serializers used by the KvState instance and this access.");
        }
        return (T)value;
    }

    public static <T> List<T> deserializeList(byte[] serializedValue, TypeSerializer<T> serializer) throws IOException {
        if (serializedValue != null) {
            DataInputDeserializer in = new DataInputDeserializer(serializedValue, 0, serializedValue.length);
            try {
                ArrayList<Object> result = new ArrayList<Object>();
                while (in.available() > 0) {
                    result.add(serializer.deserialize((DataInputView)in));
                    if (in.available() <= 0) continue;
                    in.readByte();
                }
                return result;
            }
            catch (IOException e) {
                throw new IOException("Unable to deserialize value. This indicates a mismatch in the value serializers used by the KvState instance and this access.", e);
            }
        }
        return null;
    }

    public static <UK, UV> byte[] serializeMap(Iterable<Map.Entry<UK, UV>> entries, TypeSerializer<UK> keySerializer, TypeSerializer<UV> valueSerializer) throws IOException {
        if (entries != null) {
            DataOutputSerializer dos = new DataOutputSerializer(32);
            for (Map.Entry<UK, UV> entry : entries) {
                keySerializer.serialize(entry.getKey(), (DataOutputView)dos);
                if (entry.getValue() == null) {
                    dos.writeBoolean(true);
                    continue;
                }
                dos.writeBoolean(false);
                valueSerializer.serialize(entry.getValue(), (DataOutputView)dos);
            }
            return dos.getCopyOfBuffer();
        }
        return null;
    }

    public static <UK, UV> Map<UK, UV> deserializeMap(byte[] serializedValue, TypeSerializer<UK> keySerializer, TypeSerializer<UV> valueSerializer) throws IOException {
        if (serializedValue != null) {
            DataInputDeserializer in = new DataInputDeserializer(serializedValue, 0, serializedValue.length);
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            while (in.available() > 0) {
                Object key = keySerializer.deserialize((DataInputView)in);
                boolean isNull = in.readBoolean();
                Object value = isNull ? null : valueSerializer.deserialize((DataInputView)in);
                result.put(key, value);
            }
            return result;
        }
        return null;
    }
}

