/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.history.retaining;

import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nullable;
import org.apache.flink.configuration.HistoryServerOptions;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.runtime.webmonitor.history.retaining.JobRetainedStrategy;

class TimeToLiveJobRetainedStrategy
implements JobRetainedStrategy {
    @Nullable
    private final Duration ttlThreshold;

    TimeToLiveJobRetainedStrategy(Duration ttlThreshold) {
        if (ttlThreshold != null && ttlThreshold.toMillis() <= 0L) {
            throw new IllegalConfigurationException("Cannot set %s to 0 or less than 0 milliseconds", new Object[]{HistoryServerOptions.HISTORY_SERVER_RETAINED_TTL.key()});
        }
        this.ttlThreshold = ttlThreshold;
    }

    @Override
    public boolean shouldRetain(FileStatus file, int fileOrderedIndex) {
        if (this.ttlThreshold == null) {
            return true;
        }
        return Instant.now().toEpochMilli() - file.getModificationTime() < this.ttlThreshold.toMillis();
    }
}

