/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.runtime.executiongraph.ExecutionEdge;
import org.apache.flink.runtime.executiongraph.ExecutionGate;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphIterator;
import org.apache.flink.runtime.executiongraph.ExecutionGroupEdge;
import org.apache.flink.runtime.executiongraph.ExecutionGroupVertex;
import org.apache.flink.runtime.executiongraph.ExecutionStage;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.io.network.channels.ChannelType;
import org.apache.flink.runtime.managementgraph.ManagementEdge;
import org.apache.flink.runtime.managementgraph.ManagementEdgeID;
import org.apache.flink.runtime.managementgraph.ManagementGate;
import org.apache.flink.runtime.managementgraph.ManagementGateID;
import org.apache.flink.runtime.managementgraph.ManagementGraph;
import org.apache.flink.runtime.managementgraph.ManagementGroupEdge;
import org.apache.flink.runtime.managementgraph.ManagementGroupVertex;
import org.apache.flink.runtime.managementgraph.ManagementStage;
import org.apache.flink.runtime.managementgraph.ManagementVertex;

public class ManagementGraphFactory {
    private ManagementGraphFactory() {
    }

    public static ManagementGraph fromExecutionGraph(ExecutionGraph executionGraph) {
        ManagementGraph managementGraph = new ManagementGraph(executionGraph.getJobID());
        Map<ExecutionStage, ManagementStage> stageMap = ManagementGraphFactory.addExecutionStages(managementGraph, executionGraph);
        Map<ExecutionGroupVertex, ManagementGroupVertex> groupMap = ManagementGraphFactory.addGroupVertices(stageMap);
        ManagementGraphFactory.addExecutionVertices(groupMap, executionGraph);
        return managementGraph;
    }

    private static Map<ExecutionStage, ManagementStage> addExecutionStages(ManagementGraph managementGraph, ExecutionGraph executionGraph) {
        HashMap<ExecutionStage, ManagementStage> stageMap = new HashMap<ExecutionStage, ManagementStage>();
        for (int i = 0; i < executionGraph.getNumberOfStages(); ++i) {
            ExecutionStage executionStage = executionGraph.getStage(i);
            ManagementStage managementStage = new ManagementStage(managementGraph, i);
            stageMap.put(executionStage, managementStage);
        }
        return stageMap;
    }

    private static Map<ExecutionGroupVertex, ManagementGroupVertex> addGroupVertices(Map<ExecutionStage, ManagementStage> stageMap) {
        ExecutionStage executionStage;
        HashMap<ExecutionGroupVertex, ManagementGroupVertex> groupMap = new HashMap<ExecutionGroupVertex, ManagementGroupVertex>();
        for (Map.Entry<ExecutionStage, ManagementStage> entry : stageMap.entrySet()) {
            executionStage = entry.getKey();
            ManagementStage parent = entry.getValue();
            for (int i = 0; i < executionStage.getNumberOfStageMembers(); ++i) {
                ExecutionGroupVertex groupVertex = executionStage.getStageMember(i);
                ManagementGroupVertex managementGroupVertex = new ManagementGroupVertex(parent, groupVertex.getName());
                groupMap.put(groupVertex, managementGroupVertex);
            }
        }
        for (Map.Entry<ExecutionStage, ManagementStage> entry : stageMap.entrySet()) {
            executionStage = entry.getKey();
            for (int i = 0; i < executionStage.getNumberOfStageMembers(); ++i) {
                ExecutionGroupVertex sourceVertex = executionStage.getStageMember(i);
                ManagementGroupVertex sourceGroupVertex = (ManagementGroupVertex)groupMap.get(sourceVertex);
                for (int j = 0; j < sourceVertex.getNumberOfForwardLinks(); ++j) {
                    ExecutionGroupEdge edge = sourceVertex.getForwardEdge(j);
                    ExecutionGroupVertex targetVertex = edge.getTargetVertex();
                    ManagementGroupVertex targetGroupVertex = (ManagementGroupVertex)groupMap.get(targetVertex);
                    new ManagementGroupEdge(sourceGroupVertex, j, targetGroupVertex, edge.getIndexOfInputGate(), edge.getChannelType());
                }
            }
        }
        return groupMap;
    }

    private static void addExecutionVertices(Map<ExecutionGroupVertex, ManagementGroupVertex> groupMap, ExecutionGraph executionGraph) {
        ExecutionGraphIterator iterator = new ExecutionGraphIterator(executionGraph, true);
        HashMap<ExecutionVertex, ManagementVertex> vertexMap = new HashMap<ExecutionVertex, ManagementVertex>();
        HashMap<ExecutionGate, ManagementGate> gateMap = new HashMap<ExecutionGate, ManagementGate>();
        while (iterator.hasNext()) {
            ManagementGate managementGate;
            int i;
            ExecutionVertex ev = iterator.next();
            ManagementGroupVertex parent = groupMap.get(ev.getGroupVertex());
            Instance instance = ev.getAllocatedResource().getInstance();
            ManagementVertex managementVertex = new ManagementVertex(parent, ev.getID().toManagementVertexID(), instance.getInstanceConnectionInfo() != null ? instance.getInstanceConnectionInfo().toString() : instance.toString(), ev.getIndexInVertexGroup());
            managementVertex.setExecutionState(ev.getExecutionState());
            vertexMap.put(ev, managementVertex);
            for (i = 0; i < ev.getNumberOfOutputGates(); ++i) {
                ExecutionGate outputGate = ev.getOutputGate(i);
                managementGate = new ManagementGate(managementVertex, new ManagementGateID(), i, false);
                gateMap.put(outputGate, managementGate);
            }
            for (i = 0; i < ev.getNumberOfInputGates(); ++i) {
                ExecutionGate inputGate = ev.getInputGate(i);
                managementGate = new ManagementGate(managementVertex, new ManagementGateID(), i, true);
                gateMap.put(inputGate, managementGate);
            }
        }
        iterator = new ExecutionGraphIterator(executionGraph, true);
        while (iterator.hasNext()) {
            ExecutionVertex source = iterator.next();
            for (int i = 0; i < source.getNumberOfOutputGates(); ++i) {
                ExecutionGate outputGate = source.getOutputGate(i);
                ManagementGate manangementOutputGate = (ManagementGate)gateMap.get(outputGate);
                ChannelType channelType = outputGate.getChannelType();
                for (int j = 0; j < outputGate.getNumberOfEdges(); ++j) {
                    ExecutionEdge outputChannel = outputGate.getEdge(j);
                    ManagementGate managementInputGate = (ManagementGate)gateMap.get(outputChannel.getInputGate());
                    ManagementEdgeID sourceEdgeID = new ManagementEdgeID(outputChannel.getOutputChannelID());
                    ManagementEdgeID targetEdgeID = new ManagementEdgeID(outputChannel.getInputChannelID());
                    new ManagementEdge(sourceEdgeID, targetEdgeID, manangementOutputGate, j, managementInputGate, outputChannel.getInputGateIndex(), channelType);
                }
            }
        }
    }
}

