/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang3.Validate;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.io.StringRecord;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.io.network.channels.ChannelType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphDefinitionException;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.util.EnumUtils;
import org.apache.flink.util.StringUtils;

public abstract class AbstractJobVertex
implements IOReadableWritable {
    private static final String DEFAULT_NAME = "(unnamed vertex)";
    private final ArrayList<JobEdge> forwardEdges = new ArrayList();
    private final ArrayList<JobEdge> backwardEdges = new ArrayList();
    private String name;
    private final JobVertexID id;
    private final JobGraph jobGraph;
    private int numberOfSubtasks = -1;
    private int numberOfExecutionRetries = -1;
    private AbstractJobVertex vertexToShareInstancesWith = null;
    private Configuration configuration = new Configuration();
    protected Class<? extends AbstractInvokable> invokableClass = null;

    protected AbstractJobVertex(String name, JobGraph jobGraph) {
        this(name, null, jobGraph);
    }

    protected AbstractJobVertex(String name, JobVertexID id, JobGraph jobGraph) {
        this.name = name == null ? DEFAULT_NAME : name;
        this.id = id == null ? new JobVertexID() : id;
        this.jobGraph = jobGraph;
    }

    public void connectTo(AbstractJobVertex vertex) throws JobGraphDefinitionException {
        this.connectTo(vertex, null, -1, -1, DistributionPattern.BIPARTITE);
    }

    public void connectTo(AbstractJobVertex vertex, int indexOfOutputGate, int indexOfInputGate) throws JobGraphDefinitionException {
        this.connectTo(vertex, null, indexOfOutputGate, indexOfInputGate, DistributionPattern.BIPARTITE);
    }

    public void connectTo(AbstractJobVertex vertex, ChannelType channelType) throws JobGraphDefinitionException {
        this.connectTo(vertex, channelType, -1, -1, DistributionPattern.BIPARTITE);
    }

    public void connectTo(AbstractJobVertex vertex, ChannelType channelType, DistributionPattern distributionPattern) throws JobGraphDefinitionException {
        this.connectTo(vertex, channelType, -1, -1, distributionPattern);
    }

    public void connectTo(AbstractJobVertex vertex, ChannelType channelType, int indexOfOutputGate, int indexOfInputGate, DistributionPattern distributionPattern) throws JobGraphDefinitionException {
        if (vertex == null) {
            throw new JobGraphDefinitionException("Target vertex is null!");
        }
        if (indexOfOutputGate == -1) {
            indexOfOutputGate = this.getFirstFreeOutputGateIndex();
        }
        for (int i = this.forwardEdges.size(); i <= indexOfOutputGate; ++i) {
            this.forwardEdges.add(null);
        }
        if (this.forwardEdges.get(indexOfOutputGate) != null) {
            throw new JobGraphDefinitionException("Source vertex " + this.name + " already has an edge at index " + indexOfOutputGate);
        }
        if (indexOfInputGate == -1) {
            indexOfInputGate = vertex.getFirstFreeInputGateIndex();
        } else if (vertex.getBackwardConnection(indexOfInputGate) != null) {
            throw new JobGraphDefinitionException("Target vertex " + vertex.getName() + " already has an edge at index " + indexOfInputGate);
        }
        this.forwardEdges.set(indexOfOutputGate, new JobEdge(vertex, channelType, indexOfInputGate, distributionPattern));
        vertex.connectBacklink(this, channelType, indexOfOutputGate, indexOfInputGate, distributionPattern);
    }

    protected int getFirstFreeOutputGateIndex() {
        for (int i = 0; i < this.forwardEdges.size(); ++i) {
            if (this.forwardEdges.get(i) != null) continue;
            return i;
        }
        return this.forwardEdges.size();
    }

    protected int getFirstFreeInputGateIndex() {
        for (int i = 0; i < this.backwardEdges.size(); ++i) {
            if (this.backwardEdges.get(i) != null) continue;
            return i;
        }
        return this.backwardEdges.size();
    }

    private void connectBacklink(AbstractJobVertex vertex, ChannelType channelType, int indexOfOutputGate, int indexOfInputGate, DistributionPattern distributionPattern) {
        for (int i = this.backwardEdges.size(); i <= indexOfInputGate; ++i) {
            this.backwardEdges.add(null);
        }
        this.backwardEdges.set(indexOfInputGate, new JobEdge(vertex, channelType, indexOfOutputGate, distributionPattern));
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getNumberOfForwardConnections() {
        return this.forwardEdges.size();
    }

    public int getNumberOfBackwardConnections() {
        return this.backwardEdges.size();
    }

    public JobEdge getForwardConnection(int index) {
        if (index < this.forwardEdges.size()) {
            return this.forwardEdges.get(index);
        }
        return null;
    }

    public JobEdge getBackwardConnection(int index) {
        if (index < this.backwardEdges.size()) {
            return this.backwardEdges.get(index);
        }
        return null;
    }

    public JobVertexID getID() {
        return this.id;
    }

    public void read(DataInputView in) throws IOException {
        ClassLoader cl;
        if (this.jobGraph == null) {
            throw new IOException("jobGraph is null, cannot deserialize");
        }
        this.numberOfSubtasks = in.readInt();
        this.numberOfExecutionRetries = in.readInt();
        if (in.readBoolean()) {
            JobVertexID id = new JobVertexID();
            id.read(in);
            AbstractJobVertex vertexToShareInstancesWith = this.jobGraph.findVertexByID(id);
            if (vertexToShareInstancesWith == null) {
                throw new IOException("Cannot find vertex with id " + id + " share instances with");
            }
            this.vertexToShareInstancesWith = vertexToShareInstancesWith;
        }
        if ((cl = LibraryCacheManager.getClassLoader(this.getJobGraph().getJobID())) == null) {
            throw new IOException("Cannot find class loader for vertex " + this.getID());
        }
        this.configuration = new Configuration(cl);
        this.configuration.read(in);
        int numForwardEdges = in.readInt();
        JobVertexID tmpID = new JobVertexID();
        for (int i = 0; i < numForwardEdges; ++i) {
            if (in.readBoolean()) {
                tmpID.read(in);
                AbstractJobVertex jv = this.jobGraph.findVertexByID(tmpID);
                if (jv == null) {
                    throw new IOException("Cannot find vertex with id " + tmpID);
                }
                ChannelType channelType = EnumUtils.readEnum((DataInput)in, ChannelType.class);
                DistributionPattern distributionPattern = EnumUtils.readEnum((DataInput)in, DistributionPattern.class);
                int indexOfInputGate = in.readInt();
                try {
                    this.connectTo(jv, channelType, i, indexOfInputGate, distributionPattern);
                    continue;
                }
                catch (JobGraphDefinitionException e) {
                    throw new IOException(StringUtils.stringifyException((Throwable)e));
                }
            }
            this.forwardEdges.add(null);
        }
        boolean isNotNull = in.readBoolean();
        if (!isNotNull) {
            return;
        }
        String className = StringRecord.readString((DataInput)in);
        try {
            this.invokableClass = Class.forName(className, true, cl);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Class " + className + " not found in one of the supplied jar files: " + StringUtils.stringifyException((Throwable)cnfe));
        }
    }

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.numberOfSubtasks);
        out.writeInt(this.numberOfExecutionRetries);
        if (this.vertexToShareInstancesWith != null) {
            out.writeBoolean(true);
            this.vertexToShareInstancesWith.getID().write(out);
        } else {
            out.writeBoolean(false);
        }
        this.configuration.write(out);
        out.writeInt(this.forwardEdges.size());
        for (int i = 0; i < this.forwardEdges.size(); ++i) {
            JobEdge edge = this.forwardEdges.get(i);
            if (edge == null) {
                out.writeBoolean(false);
                continue;
            }
            out.writeBoolean(true);
            edge.getConnectedVertex().getID().write(out);
            EnumUtils.writeEnum((DataOutput)out, edge.getChannelType());
            EnumUtils.writeEnum((DataOutput)out, edge.getDistributionPattern());
            out.writeInt(edge.getIndexOfInputGate());
        }
        if (this.invokableClass == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        StringRecord.writeString((DataOutput)out, (String)this.invokableClass.getName());
    }

    public JobGraph getJobGraph() {
        return this.jobGraph;
    }

    public void setNumberOfSubtasks(int numberOfSubtasks) {
        this.numberOfSubtasks = numberOfSubtasks;
    }

    public int getNumberOfSubtasks() {
        return this.numberOfSubtasks;
    }

    public void setNumberOfExecutionRetries(int numberOfExecutionRetries) {
        this.numberOfExecutionRetries = numberOfExecutionRetries;
    }

    public int getNumberOfExecutionRetries() {
        return this.numberOfExecutionRetries;
    }

    public void setVertexToShareInstancesWith(AbstractJobVertex vertex) {
        this.vertexToShareInstancesWith = vertex;
    }

    public AbstractJobVertex getVertexToShareInstancesWith() {
        return this.vertexToShareInstancesWith;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setInvokableClass(Class<? extends AbstractInvokable> invokable) {
        Validate.notNull(invokable);
        this.invokableClass = invokable;
    }

    public Class<? extends AbstractInvokable> getInvokableClass() {
        return this.invokableClass;
    }

    public String toString() {
        return this.name + " (" + this.invokableClass + ')';
    }
}

