/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.shipping;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.io.network.api.RecordWriter;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.util.Collector;

public class OutputCollector<T>
implements Collector<T> {
    protected RecordWriter<SerializationDelegate<T>>[] writers;
    private final SerializationDelegate<T> delegate;

    public OutputCollector(List<RecordWriter<SerializationDelegate<T>>> writers, TypeSerializer<T> serializer) {
        this.delegate = new SerializationDelegate<T>(serializer);
        this.writers = writers.toArray(new RecordWriter[writers.size()]);
    }

    public void addWriter(RecordWriter<SerializationDelegate<T>> writer) {
        if (this.writers == null) {
            this.writers = new RecordWriter[]{writer};
        } else {
            RecordWriter[] ws = new RecordWriter[this.writers.length + 1];
            System.arraycopy(this.writers, 0, ws, 0, this.writers.length);
            ws[this.writers.length] = writer;
            this.writers = ws;
        }
    }

    public void collect(T record) {
        this.delegate.setInstance(record);
        try {
            for (int i = 0; i < this.writers.length; ++i) {
                this.writers[i].emit(this.delegate);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Emitting the record caused an I/O exception: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Emitting the record was interrupted: " + e.getMessage(), e);
        }
    }

    public void close() {
        for (RecordWriter<SerializationDelegate<T>> writer : this.writers) {
            try {
                writer.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public List<RecordWriter<SerializationDelegate<T>>> getWriters() {
        return Collections.unmodifiableList(Arrays.asList(this.writers));
    }
}

