/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.UserGroupInformation;

public class EnvironmentInformation {
    private static final Log LOG = LogFactory.getLog(EnvironmentInformation.class);
    private static final String UNKNOWN = "<unknown>";
    private static final String LOG_FILE_OPTION = "-Dlog.file";
    private static final String LOG_CONFIGURAION_OPTION = "-Dlog4j.configuration";

    public static String getVersion() {
        return EnvironmentInformation.class.getPackage().getImplementationVersion();
    }

    public static RevisionInformation getRevisionInformation() {
        RevisionInformation info = new RevisionInformation();
        String revision = UNKNOWN;
        String commitDate = UNKNOWN;
        try {
            Properties properties = new Properties();
            InputStream propFile = EnvironmentInformation.class.getClassLoader().getResourceAsStream(".version.properties");
            if (propFile != null) {
                properties.load(propFile);
                revision = properties.getProperty("git.commit.id.abbrev");
                commitDate = properties.getProperty("git.commit.time");
            }
        }
        catch (Throwable t) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Cannot determine code revision: Unable ro read version property file.", t);
            }
            LOG.info((Object)"Cannot determine code revision: Unable ro read version property file.");
        }
        info.commitId = revision;
        info.commitDate = commitDate;
        return info;
    }

    public static String getUserRunning() {
        try {
            return UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (Throwable t) {
            String user;
            if (LOG.isDebugEnabled() && !(t instanceof ClassNotFoundException)) {
                LOG.debug((Object)"Cannot determine user/group information using Hadoop utils.", t);
            }
            if ((user = System.getProperty("user.name")) == null) {
                user = UNKNOWN;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Cannot determine user/group information for the current user.");
                }
            }
            return user;
        }
    }

    public static long getMaxJvmMemory() {
        return Runtime.getRuntime().maxMemory() >>> 20;
    }

    public static String getJvmVersion() {
        try {
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            return bean.getVmName() + " - " + bean.getVmVendor() + " - " + bean.getSpecVersion() + '/' + bean.getVmVersion();
        }
        catch (Throwable t) {
            return UNKNOWN;
        }
    }

    public static String getJvmStartupOptions() {
        try {
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            StringBuilder bld = new StringBuilder();
            for (String s : bean.getInputArguments()) {
                if (s.startsWith(LOG_FILE_OPTION) || s.startsWith(LOG_CONFIGURAION_OPTION)) continue;
                bld.append(s).append(' ');
            }
            return bld.toString();
        }
        catch (Throwable t) {
            return UNKNOWN;
        }
    }

    public static void logEnvironmentInfo(Log log, String componentName) {
        if (log.isInfoEnabled()) {
            RevisionInformation rev = EnvironmentInformation.getRevisionInformation();
            String version = EnvironmentInformation.getVersion();
            String user = EnvironmentInformation.getUserRunning();
            String jvmVersion = EnvironmentInformation.getJvmVersion();
            String options = EnvironmentInformation.getJvmStartupOptions();
            String javaHome = System.getenv("JAVA_HOME");
            long memory = EnvironmentInformation.getMaxJvmMemory();
            log.info((Object)"-------------------------------------------------------");
            log.info((Object)(" Starting " + componentName + " (Version: " + version + ", " + "Rev:" + rev.commitId + ", " + "Date:" + rev.commitDate + ")"));
            log.info((Object)(" Current user: " + user));
            log.info((Object)(" JVM: " + jvmVersion));
            log.info((Object)(" Startup Options: " + options));
            log.info((Object)(" Maximum heap size: " + memory + " MiBytes"));
            log.info((Object)(" JAVA_HOME: " + (javaHome == null ? "not set" : javaHome)));
            log.info((Object)"-------------------------------------------------------");
        }
    }

    private EnvironmentInformation() {
    }

    public static void main(String[] args) {
        EnvironmentInformation.logEnvironmentInfo(LOG, "Test");
    }

    public static class RevisionInformation {
        public String commitId;
        public String commitDate;
    }
}

