/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.resettable;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memorymanager.MemoryAllocationException;
import org.apache.flink.runtime.memorymanager.MemoryManager;
import org.apache.flink.runtime.operators.resettable.AbstractBlockResettableIterator;
import org.apache.flink.runtime.util.ResettableMutableObjectIterator;
import org.apache.flink.util.MutableObjectIterator;

public class BlockResettableMutableObjectIterator<T>
extends AbstractBlockResettableIterator<T>
implements ResettableMutableObjectIterator<T> {
    public static final Log LOG = LogFactory.getLog(BlockResettableMutableObjectIterator.class);
    private final MutableObjectIterator<T> input;
    private boolean readPhase;
    private boolean leftOverReturned;
    private boolean fullWriteBuffer;
    private boolean noMoreBlocks;
    private T leftOverRecord;

    public BlockResettableMutableObjectIterator(MemoryManager memoryManager, MutableObjectIterator<T> input, TypeSerializer<T> serializer, int numMemoryPages, AbstractInvokable ownerTask) throws MemoryAllocationException {
        super(serializer, memoryManager, numMemoryPages, ownerTask);
        this.input = input;
        this.leftOverRecord = serializer.createInstance();
        this.leftOverReturned = true;
    }

    public T next(T target) throws IOException {
        if (this.readPhase) {
            return this.getNextRecord(target);
        }
        if (this.leftOverReturned) {
            if ((target = this.input.next(target)) != null) {
                if (this.writeNextRecord(target)) {
                    return target;
                }
                this.leftOverRecord = this.serializer.copy(target, this.leftOverRecord);
                this.leftOverReturned = false;
                this.fullWriteBuffer = true;
                return null;
            }
            this.noMoreBlocks = true;
            return null;
        }
        if (this.fullWriteBuffer) {
            return null;
        }
        this.leftOverReturned = true;
        target = this.serializer.copy(this.leftOverRecord, target);
        return target;
    }

    @Override
    public void reset() {
        this.readPhase = true;
        super.reset();
    }

    @Override
    public boolean nextBlock() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Iterator has been closed.");
        }
        if (this.noMoreBlocks) {
            return false;
        }
        super.nextBlock();
        if (this.leftOverReturned || !this.fullWriteBuffer) {
            this.leftOverRecord = this.input.next(this.leftOverRecord);
            if (this.leftOverRecord != null) {
                this.leftOverReturned = false;
            } else {
                this.noMoreBlocks = true;
                this.fullWriteBuffer = true;
                this.readPhase = false;
                return false;
            }
        }
        if (!this.writeNextRecord(this.leftOverRecord)) {
            throw new IOException("BlockResettableIterator could not serialize record into fresh memory block: Record is too large.");
        }
        this.readPhase = false;
        this.fullWriteBuffer = false;
        return true;
    }

    public boolean hasFurtherInput() {
        return !this.noMoreBlocks;
    }

    @Override
    public void close() {
        this.readPhase = true;
        super.close();
    }
}

