/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.S3Object;
import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.util.StringUtils;

public class S3DataInputStream
extends FSDataInputStream {
    private final InputStream inputStream;

    S3DataInputStream(AmazonS3Client s3Client, String bucket, String object) throws IOException {
        S3Object s3o = null;
        try {
            s3o = s3Client.getObject(bucket, object);
        }
        catch (AmazonServiceException e) {
            throw new IOException(StringUtils.stringifyException((Throwable)e));
        }
        this.inputStream = s3o.getObjectContent();
    }

    public int available() throws IOException {
        return this.inputStream.available();
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    public int read() throws IOException {
        return this.inputStream.read();
    }

    public int read(byte[] b) throws IOException {
        return this.inputStream.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.inputStream.read(b, off, len);
    }

    public void reset() throws IOException {
        this.inputStream.reset();
    }

    public void seek(long desired) throws IOException {
        this.inputStream.skip(desired);
    }
}

