/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.profiling.types;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.managementgraph.ManagementVertexID;
import org.apache.flink.runtime.profiling.types.VertexProfilingEvent;

public final class InputGateProfilingEvent
extends VertexProfilingEvent {
    private int gateIndex;
    private int noRecordsAvailableCounter;

    public InputGateProfilingEvent(int gateIndex, int noRecordsAvailableCounter, ManagementVertexID vertexID, int profilingInterval, JobID jobID, long timestamp, long profilingTimestamp) {
        super(vertexID, profilingInterval, jobID, timestamp, profilingTimestamp);
        this.gateIndex = gateIndex;
        this.noRecordsAvailableCounter = noRecordsAvailableCounter;
    }

    public InputGateProfilingEvent() {
    }

    public int getGateIndex() {
        return this.gateIndex;
    }

    public int getNoRecordsAvailableCounter() {
        return this.noRecordsAvailableCounter;
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.gateIndex = in.readInt();
        this.noRecordsAvailableCounter = in.readInt();
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        out.writeInt(this.gateIndex);
        out.writeInt(this.noRecordsAvailableCounter);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof InputGateProfilingEvent)) {
            return false;
        }
        InputGateProfilingEvent inputGateProfilingEvent = (InputGateProfilingEvent)obj;
        if (this.gateIndex != inputGateProfilingEvent.getGateIndex()) {
            return false;
        }
        return this.noRecordsAvailableCounter == inputGateProfilingEvent.getNoRecordsAvailableCounter();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

