/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.execution.librarycache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.io.StringRecord;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class LibraryCacheProfileRequest
implements IOReadableWritable {
    private String[] requiredLibraries;

    public String[] getRequiredLibraries() {
        return this.requiredLibraries;
    }

    public void setRequiredLibraries(String[] requiredLibraries) {
        this.requiredLibraries = requiredLibraries;
    }

    public void read(DataInputView in) throws IOException {
        this.requiredLibraries = new String[in.readInt()];
        for (int i = 0; i < this.requiredLibraries.length; ++i) {
            this.requiredLibraries[i] = StringRecord.readString((DataInput)in);
        }
    }

    public void write(DataOutputView out) throws IOException {
        if (this.requiredLibraries == null) {
            throw new IOException("requiredLibraries is null");
        }
        out.writeInt(this.requiredLibraries.length);
        for (int i = 0; i < this.requiredLibraries.length; ++i) {
            StringRecord.writeString((DataOutput)out, (String)this.requiredLibraries[i]);
        }
    }
}

