/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGroupVertex;
import org.apache.flink.runtime.executiongraph.ExecutionStage;

public class ExecutionGroupVertexIterator
implements Iterator<ExecutionGroupVertex> {
    private final boolean forward;
    private final int stage;
    private final List<ExecutionGroupVertex> entryVertices = new ArrayList<ExecutionGroupVertex>();
    private int numVisitedEntryVertices = 0;
    private final Stack<TraversalEntry> traversalStack = new Stack();
    private final Set<ExecutionGroupVertex> alreadyVisited = new HashSet<ExecutionGroupVertex>();

    public ExecutionGroupVertexIterator(ExecutionGraph executionGraph, boolean forward, int stage) {
        this.forward = forward;
        this.stage = stage;
        if (stage < 0) {
            for (int i = 0; i < executionGraph.getNumberOfStages(); ++i) {
                this.collectStartVertices(executionGraph.getStage(i));
            }
        } else if (stage < executionGraph.getNumberOfStages()) {
            this.collectStartVertices(executionGraph.getStage(stage));
        }
        if (this.entryVertices.size() > 0) {
            TraversalEntry te = new TraversalEntry(this.entryVertices.get(0), 0);
            this.traversalStack.push(te);
            this.alreadyVisited.add(te.getGroupVertex());
        }
    }

    private void collectStartVertices(ExecutionStage stage) {
        for (int i = 0; i < stage.getNumberOfStageMembers(); ++i) {
            ExecutionGroupVertex groupVertex = stage.getStageMember(i);
            if (this.forward) {
                if (groupVertex.getNumberOfBackwardLinks() != 0 && (this.stage < 0 || !this.allConnectionsFromOtherStage(groupVertex, true))) continue;
                this.entryVertices.add(groupVertex);
                continue;
            }
            if (groupVertex.getNumberOfForwardLinks() != 0 && (this.stage < 0 || !this.allConnectionsFromOtherStage(groupVertex, false))) continue;
            this.entryVertices.add(groupVertex);
        }
    }

    private boolean allConnectionsFromOtherStage(ExecutionGroupVertex groupVertex, boolean forward) {
        if (forward) {
            for (int i = 0; i < groupVertex.getNumberOfBackwardLinks(); ++i) {
                if (this.stage != groupVertex.getBackwardEdge(i).getSourceVertex().getStageNumber()) continue;
                return false;
            }
        } else {
            for (int i = 0; i < groupVertex.getNumberOfForwardLinks(); ++i) {
                if (this.stage != groupVertex.getForwardEdge(i).getTargetVertex().getStageNumber()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        if (this.traversalStack.isEmpty()) {
            ++this.numVisitedEntryVertices;
            if (this.entryVertices.size() <= this.numVisitedEntryVertices) {
                return false;
            }
        }
        return true;
    }

    @Override
    public ExecutionGroupVertex next() {
        if (this.traversalStack.isEmpty()) {
            TraversalEntry newentry = new TraversalEntry(this.entryVertices.get(this.numVisitedEntryVertices), 0);
            this.traversalStack.push(newentry);
            this.alreadyVisited.add(newentry.getGroupVertex());
        }
        ExecutionGroupVertex returnVertex = this.traversalStack.peek().getGroupVertex();
        do {
            TraversalEntry te;
            ExecutionGroupVertex candidateVertex;
            if ((candidateVertex = this.getCandidateVertex(te = this.traversalStack.peek(), this.forward)) != null) {
                TraversalEntry newte = new TraversalEntry(candidateVertex, 0);
                this.traversalStack.push(newte);
                this.alreadyVisited.add(newte.getGroupVertex());
                break;
            }
            this.traversalStack.pop();
        } while (!this.traversalStack.isEmpty());
        return returnVertex;
    }

    private ExecutionGroupVertex getCandidateVertex(TraversalEntry te, boolean forward) {
        while (!(forward ? te.getCurrentLink() >= te.getGroupVertex().getNumberOfForwardLinks() : te.getCurrentLink() >= te.getGroupVertex().getNumberOfBackwardLinks())) {
            ExecutionGroupVertex tmp = null;
            tmp = forward ? te.getGroupVertex().getForwardEdge(te.getCurrentLink()).getTargetVertex() : te.getGroupVertex().getBackwardEdge(te.getCurrentLink()).getSourceVertex();
            te.increaseCurrentLink();
            if (this.stage >= 0 && tmp.getStageNumber() != this.stage || this.alreadyVisited.contains(tmp)) continue;
            return tmp;
        }
        return null;
    }

    @Override
    public void remove() {
    }

    private static class TraversalEntry {
        private final ExecutionGroupVertex groupVertex;
        private int currentLink = 0;

        public TraversalEntry(ExecutionGroupVertex groupVertex, int currentLink) {
            this.groupVertex = groupVertex;
            this.currentLink = currentLink;
        }

        public ExecutionGroupVertex getGroupVertex() {
            return this.groupVertex;
        }

        public int getCurrentLink() {
            return this.currentLink;
        }

        public void increaseCurrentLink() {
            ++this.currentLink;
        }
    }
}

