/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api;

import java.io.IOException;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.network.api.AbstractSingleGateRecordReader;
import org.apache.flink.runtime.io.network.api.MutableReader;
import org.apache.flink.runtime.io.network.gates.InputChannelResult;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;

public class MutableRecordReader<T extends IOReadableWritable>
extends AbstractSingleGateRecordReader<T>
implements MutableReader<T> {
    private boolean endOfStream;

    public MutableRecordReader(AbstractInvokable taskBase) {
        super(taskBase);
    }

    @Override
    public boolean next(T target) throws IOException, InterruptedException {
        if (this.endOfStream) {
            return false;
        }
        while (true) {
            InputChannelResult result = this.inputGate.readRecord(target);
            switch (result) {
                case INTERMEDIATE_RECORD_FROM_BUFFER: 
                case LAST_RECORD_FROM_BUFFER: {
                    return true;
                }
                case END_OF_SUPERSTEP: {
                    if (!this.incrementEndOfSuperstepEventAndCheck()) break;
                    return false;
                }
                case TASK_EVENT: {
                    this.handleEvent(this.inputGate.getCurrentEvent());
                    break;
                }
                case END_OF_STREAM: {
                    this.endOfStream = true;
                    return false;
                }
            }
        }
    }

    @Override
    public boolean isInputClosed() {
        return this.endOfStream;
    }

    @Override
    public void setIterative(int numEventsUntilEndOfSuperstep) {
        if (numEventsUntilEndOfSuperstep != this.getNumberOfInputChannels()) {
            throw new IllegalArgumentException("Number of events till end of superstep is different from the number of input channels.");
        }
        super.setIterative(numEventsUntilEndOfSuperstep);
    }
}

