/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.splitassigner.file;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.runtime.executiongraph.ExecutionGroupVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.jobmanager.splitassigner.InputSplitAssigner;
import org.apache.flink.runtime.jobmanager.splitassigner.file.FileInputSplitList;

public final class FileInputSplitAssigner
implements InputSplitAssigner {
    private static final Log LOG = LogFactory.getLog(FileInputSplitAssigner.class);
    private final ConcurrentMap<ExecutionGroupVertex, FileInputSplitList> vertexMap = new ConcurrentHashMap<ExecutionGroupVertex, FileInputSplitList>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerGroupVertex(ExecutionGroupVertex groupVertex) {
        if (!FileInputSplit.class.equals(groupVertex.getInputSplitType())) {
            LOG.error((Object)(groupVertex.getName() + " produces input splits of type " + groupVertex.getInputSplitType() + " and cannot be handled by this split assigner"));
            return;
        }
        InputSplit[] inputSplits = groupVertex.getInputSplits();
        if (inputSplits == null) {
            return;
        }
        if (inputSplits.length == 0) {
            return;
        }
        FileInputSplitList splitStore = new FileInputSplitList();
        if (this.vertexMap.putIfAbsent(groupVertex, splitStore) != null) {
            LOG.error((Object)(groupVertex.getName() + " appears to be already registered with the file input split assigner, ignoring vertex..."));
            return;
        }
        FileInputSplitList fileInputSplitList = splitStore;
        synchronized (fileInputSplitList) {
            for (int i = 0; i < inputSplits.length; ++i) {
                InputSplit inputSplit = inputSplits[i];
                if (!(inputSplit instanceof FileInputSplit)) {
                    LOG.error((Object)("Input split " + i + " of vertex " + groupVertex.getName() + " is of type " + inputSplit.getClass() + ", ignoring split..."));
                    continue;
                }
                splitStore.addSplit((FileInputSplit)inputSplit);
            }
        }
    }

    @Override
    public void unregisterGroupVertex(ExecutionGroupVertex groupVertex) {
        this.vertexMap.remove(groupVertex);
    }

    @Override
    public InputSplit getNextInputSplit(ExecutionVertex vertex) {
        ExecutionGroupVertex groupVertex = vertex.getGroupVertex();
        FileInputSplitList splitStore = (FileInputSplitList)this.vertexMap.get(groupVertex);
        if (splitStore == null) {
            return null;
        }
        Instance instance = vertex.getAllocatedResource().getInstance();
        if (instance == null) {
            LOG.error((Object)"Instance is null, returning random split");
            return null;
        }
        return splitStore.getNextInputSplit(instance);
    }
}

