/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeComparatorFactory;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypePairComparatorFactory;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.iterative.concurrent.SolutionSetBroker;
import org.apache.flink.runtime.iterative.task.AbstractIterativePactTask;
import org.apache.flink.runtime.operators.PactTaskContext;
import org.apache.flink.runtime.operators.ResettablePactDriver;
import org.apache.flink.runtime.operators.hash.AbstractHashTableProber;
import org.apache.flink.runtime.operators.hash.CompactingHashTable;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;

public class JoinWithSolutionSetSecondDriver<IT1, IT2, OT>
implements ResettablePactDriver<FlatJoinFunction<IT1, IT2, OT>, OT> {
    private PactTaskContext<FlatJoinFunction<IT1, IT2, OT>, OT> taskContext;
    private CompactingHashTable<IT2> hashTable;
    private TypeComparator<IT1> probeSideComparator;
    private TypePairComparator<IT1, IT2> pairComparator;
    private IT2 solutionSideRecord;
    private IT1 probeSideRecord;
    protected volatile boolean running;

    @Override
    public void setup(PactTaskContext<FlatJoinFunction<IT1, IT2, OT>, OT> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<FlatJoinFunction<IT1, IT2, OT>> getStubType() {
        Class<FlatJoinFunction> clazz = FlatJoinFunction.class;
        return clazz;
    }

    @Override
    public boolean requiresComparatorOnInput() {
        return true;
    }

    @Override
    public boolean isInputResettable(int inputNum) {
        if (inputNum < 0 || inputNum > 1) {
            throw new IndexOutOfBoundsException();
        }
        return false;
    }

    @Override
    public void initialize() throws Exception {
        if (!(this.taskContext instanceof AbstractIterativePactTask)) {
            throw new Exception("The task context of this driver is no iterative task context.");
        }
        AbstractIterativePactTask iterativeTaskContext = (AbstractIterativePactTask)this.taskContext;
        String identifier = iterativeTaskContext.brokerKey();
        this.hashTable = SolutionSetBroker.instance().get(identifier);
        TaskConfig config = this.taskContext.getTaskConfig();
        ClassLoader classLoader = this.taskContext.getUserCodeClassLoader();
        TypeSerializer solutionSetSerializer = this.hashTable.getBuildSideSerializer();
        TypeSerializer probeSideSerializer = this.taskContext.getInputSerializer(0).getSerializer();
        TypeComparatorFactory probeSideComparatorFactory = config.getDriverComparator(0, classLoader);
        TypeComparator solutionSetComparator = this.hashTable.getBuildSideComparator().duplicate();
        this.probeSideComparator = probeSideComparatorFactory.createComparator();
        this.solutionSideRecord = solutionSetSerializer.createInstance();
        this.probeSideRecord = probeSideSerializer.createInstance();
        TypePairComparatorFactory factory = this.taskContext.getTaskConfig().getPairComparatorFactory(this.taskContext.getUserCodeClassLoader());
        this.pairComparator = factory.createComparator12(this.probeSideComparator, solutionSetComparator);
    }

    @Override
    public void prepare() {
    }

    @Override
    public void run() throws Exception {
        FlatJoinFunction<IT1, IT2, OT> joinFunction = this.taskContext.getStub();
        Collector<OT> collector = this.taskContext.getOutputCollector();
        IT2 buildSideRecord = this.solutionSideRecord;
        Object probeSideRecord = this.probeSideRecord;
        CompactingHashTable<IT2> join = this.hashTable;
        MutableObjectIterator probeSideInput = this.taskContext.getInput(0);
        AbstractHashTableProber prober = join.getProber((TypeComparator)this.probeSideComparator, (TypePairComparator)this.pairComparator);
        while (this.running && (probeSideRecord = probeSideInput.next(probeSideRecord)) != null) {
            buildSideRecord = ((CompactingHashTable.HashTableProber)prober).getMatchFor(probeSideRecord, buildSideRecord);
            joinFunction.join(probeSideRecord, buildSideRecord, collector);
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void reset() {
    }

    @Override
    public void teardown() {
    }

    @Override
    public void cancel() {
        this.running = false;
    }
}

